/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice;

import de.winkler.betoffice.SpringBeans;
import de.winkler.betoffice.service.MasterDataManagerService;
import de.winkler.betoffice.service.SeasonManagerService;
import de.winkler.betoffice.service.TippService;
import de.winkler.betoffice.util.LoggerFactory;
import java.util.ArrayList;
import org.slf4j.Logger;

public class BetofficeStore {
    private final Logger log = LoggerFactory.make();
    private final SpringBeans springBeans;
    private final SeasonManagerService sms;
    private final TippService tippService;
    private final MasterDataManagerService mdms;

    public BetofficeStore(String appContextUserProperties) {
        this(new String[]{appContextUserProperties});
    }

    public BetofficeStore(String[] applicationResources) {
        ArrayList<String> confs = new ArrayList<String>();
        confs.add("classpath:betoffice-datasource.xml");
        confs.add("classpath:betoffice-persistence.xml");
        confs.add("file:hibernate.xml");
        for (String resource : applicationResources) {
            confs.add(resource);
        }
        String[] resources = confs.toArray(new String[confs.size()]);
        if (this.log.isInfoEnabled()) {
            for (String resource : resources) {
                this.log.info("Resource: " + resource);
            }
        }
        this.springBeans = new SpringBeans(resources);
        this.sms = (SeasonManagerService)this.springBeans.getBean("seasonManagerService");
        this.mdms = (MasterDataManagerService)this.springBeans.getBean("masterDataManagerService");
        this.tippService = (TippService)this.springBeans.getBean("tippService");
    }

    public final SpringBeans getBeans() {
        return this.springBeans;
    }

    public final SeasonManagerService getSeasonManagerService() {
        return this.sms;
    }

    public final TippService getTippService() {
        return this.tippService;
    }

    public final MasterDataManagerService getMasterDataManagerService() {
        return this.mdms;
    }
}

