/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.dao.hibernate;

import de.winkler.betoffice.dao.CommunityDao;
import de.winkler.betoffice.dao.hibernate.AbstractCommonDao;
import de.winkler.betoffice.storage.Community;
import de.winkler.betoffice.storage.User;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository(value="communityDao")
public class CommunityDaoHibernate
extends AbstractCommonDao<Community>
implements CommunityDao {
    public CommunityDaoHibernate() {
        super(Community.class);
    }

    @Override
    public List<Community> findAll(String nameFilter) {
        String filter = "%" + nameFilter + "%";
        return this.getSessionFactory().getCurrentSession().createQuery("from Community c where LOWER(c.name) like LOWER(:filter)", Community.class).setParameter("filter", (Object)filter).getResultList();
    }

    @Override
    public Community find(String name) {
        return (Community)this.getSessionFactory().getCurrentSession().createQuery("from Community c where c.name = :name", Community.class).setParameter("name", (Object)name).getSingleResult();
    }

    @Override
    public Community findCommunityMembers(String name) {
        return (Community)this.getSessionFactory().getCurrentSession().createQuery("from Community c left join fetch c.users where c.name = :name", Community.class).setParameter("name", (Object)name).getSingleResult();
    }

    @Override
    public boolean hasMembers(Community community) {
        List members = this.getSessionFactory().getCurrentSession().createQuery("from Community c left join fetch c.users where c.id = :id", User.class).setParameter("id", (Object)community.getId()).getResultList();
        return members.size() > 0;
    }

    @Override
    public List<User> findMembers(Community community) {
        return this.getSessionFactory().getCurrentSession().createQuery("from Community c left join fetch c.users where c.id = :id", User.class).setParameter("id", (Object)community.getId()).getResultList();
    }
}

