/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.dao.hibernate;

import de.winkler.betoffice.dao.UserSeasonDao;
import de.winkler.betoffice.dao.hibernate.AbstractCommonDao;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.User;
import de.winkler.betoffice.storage.UserSeason;
import java.util.List;
import java.util.Optional;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository(value="userSasonDao")
public class UserSeasonDaoHibernate
extends AbstractCommonDao<UserSeason>
implements UserSeasonDao {
    private static final String QUERY_USERS_BY_SEASON = "select user from User user, UserSeason us where us.season.id = :seasonId and us.user.id = user.id order by user.nickname";

    public UserSeasonDaoHibernate() {
        super(UserSeason.class);
    }

    @Override
    public List<User> findUsers(Season season) {
        List users = this.getSessionFactory().getCurrentSession().createQuery(QUERY_USERS_BY_SEASON, User.class).setParameter("seasonId", (Object)season.getId()).getResultList();
        return users;
    }

    @Override
    public Optional<UserSeason> findUserSeason(Season season, User user) {
        Query query = this.getSessionFactory().getCurrentSession().createQuery("from UserSeason us where us.season.id = :seasonId and us.user.id = :userId").setParameter("seasonId", (Object)season.getId()).setParameter("userId", (Object)user.getId());
        return UserSeasonDaoHibernate.singleResult(query);
    }
}

