/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.storage;

import de.winkler.betoffice.storage.AbstractStorageObject;
import de.winkler.betoffice.storage.Game;
import de.winkler.betoffice.storage.GameResult;
import de.winkler.betoffice.storage.User;
import de.winkler.betoffice.storage.UserResult;
import de.winkler.betoffice.storage.enums.TippStatusType;
import de.winkler.betoffice.storage.enums.TotoResult;
import java.util.Comparator;
import java.util.Date;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="bo_gametipp")
public class GameTipp
extends AbstractStorageObject
implements Comparator<GameTipp> {
    private static final long serialVersionUID = -3043191976453282242L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", updatable=false, nullable=false)
    private Long id;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(column=@Column(name="bo_homegoals"), name="homeGoals"), @AttributeOverride(column=@Column(name="bo_guestgoals"), name="guestGoals")})
    private GameResult tipp = new GameResult();
    @Column(name="bo_create")
    private Date creationTime;
    @Column(name="bo_update")
    private Date lastUpdateTime;
    @ManyToOne
    @JoinColumn(name="bo_user_ref")
    private User user;
    @Column(name="bo_token")
    private String token;
    @ManyToOne(optional=false)
    @JoinColumn(name="bo_game_ref")
    private Game game;
    @Enumerated
    @Column(name="bo_status")
    private TippStatusType status = TippStatusType.UNDEFINED;

    @Override
    public Long getId() {
        return this.id;
    }

    protected void setId(Long value) {
        this.id = value;
    }

    public GameResult getTipp() {
        return this.tipp;
    }

    private void setTipp(GameResult value) {
        this.tipp = value;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date date) {
        this.creationTime = date;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Date _lastUpdateTime) {
        this.lastUpdateTime = _lastUpdateTime;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User value) {
        this.user = value;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String _token) {
        this.token = _token;
    }

    public Game getGame() {
        return this.game;
    }

    public void setGame(Game value) {
        this.game = value;
    }

    public TotoResult getTotoResult() {
        return this.calcTippResult();
    }

    public TippStatusType getStatus() {
        return this.status;
    }

    private void setStatus(TippStatusType value) {
        this.status = value;
    }

    public boolean isInvalid() {
        return TippStatusType.INVALID.equals((Object)this.getStatus());
    }

    public void setTipp(int homeGoals, int guestGoals, TippStatusType theStatus) {
        this.setStatus(theStatus);
        this.setTipp(new GameResult(homeGoals, guestGoals));
    }

    public void setTipp(GameResult _result, TippStatusType _status) {
        this.setStatus(_status);
        this.setTipp(_result);
    }

    public long getPoints() {
        if (this.getTotoResult().equals(TotoResult.EQUAL)) {
            return UserResult.nEqualValue;
        }
        if (this.getTotoResult().equals(TotoResult.TOTO)) {
            return UserResult.nTotoValue;
        }
        if (this.getTotoResult().equals(TotoResult.ZERO)) {
            return UserResult.nZeroValue;
        }
        if (this.getTotoResult().equals(TotoResult.UNDEFINED)) {
            return UserResult.nZeroValue;
        }
        throw new IllegalStateException();
    }

    private TotoResult calcTippResult() {
        if (this.game == null || this.tipp == null) {
            return TotoResult.UNDEFINED;
        }
        if (!this.game.isPlayed()) {
            return TotoResult.UNDEFINED;
        }
        if (this.game.isKo()) {
            if (!this.game.getResult().isRemis()) {
                return this.calcTotoResult(this.game.getResult());
            }
            if (this.game.getResult().isRemis() && !this.game.getOverTimeGoals().isRemis()) {
                return this.calcTotoResult(this.game.getOverTimeGoals());
            }
            if (this.game.getResult().isRemis() && this.game.getOverTimeGoals().isRemis()) {
                return this.calcTotoResult(this.game.getPenaltyGoals());
            }
        }
        return this.calcTotoResult(this.game.getResult());
    }

    private TotoResult calcTotoResult(GameResult gameResult) {
        if (gameResult.equals(this.tipp)) {
            return TotoResult.EQUAL;
        }
        if (gameResult.getToto().equals(this.tipp.getToto())) {
            return TotoResult.TOTO;
        }
        return TotoResult.ZERO;
    }

    @Override
    public int compare(GameTipp o1, GameTipp o2) {
        if (o1.getPoints() > o2.getPoints()) {
            return 1;
        }
        if (o1.getPoints() == o2.getPoints()) {
            return 0;
        }
        return -1;
    }

    public int hashCode() {
        return 13;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GameTipp other = (GameTipp)obj;
        return this.id != null && this.id.equals(other.getId());
    }

    public String debug() {
        return "GameTipp [id=" + this.id + ", tipp=" + this.tipp + ", creationTime=" + this.creationTime + ", lastUpdateTime=" + this.lastUpdateTime + ", user=" + this.user + ", game=" + this.game.debug() + ", status=" + this.status + "]";
    }
}

