/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.tippengine;

import de.winkler.betoffice.service.SeasonManagerService;
import de.winkler.betoffice.service.TippService;
import de.winkler.betoffice.storage.Game;
import de.winkler.betoffice.storage.GameList;
import de.winkler.betoffice.storage.GameResult;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.User;
import de.winkler.betoffice.storage.enums.TippStatusType;
import de.winkler.betoffice.tippengine.InfoCenter;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MediumTippGenerator {
    private final String BOT_MEDIUM_TIPP = "#BOT_MEDIUM_TIPP#";
    @Autowired
    private InfoCenter infoCenter;
    @Autowired
    private TippService tippService;
    @Autowired
    private SeasonManagerService seasonManagerService;

    @Transactional
    public void generateTipp(Season season, User user) {
        for (GameList gameList : season.toGameList()) {
            this.generateTipp(gameList, user);
        }
    }

    @Transactional
    public void generateTipp(GameList round, User user) {
        List<User> users = this.seasonManagerService.findActivatedUsers(round.getSeason());
        List<Game> games = round.unmodifiableList();
        for (Game game : games) {
            GameResult gr = this.infoCenter.findMediumTipp(game, users);
            if (gr == null) continue;
            this.tippService.createOrUpdateTipp("#BOT_MEDIUM_TIPP#", game, user, gr, TippStatusType.AUTO);
        }
    }
}

