/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.dao.hibernate;

import de.winkler.betoffice.dao.CommunityDao;
import de.winkler.betoffice.dao.hibernate.AbstractCommonDao;
import de.winkler.betoffice.dao.hibernate.FilterBuilder;
import de.winkler.betoffice.storage.Community;
import de.winkler.betoffice.storage.CommunityFilter;
import de.winkler.betoffice.storage.CommunityReference;
import de.winkler.betoffice.storage.SeasonReference;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hibernate.query.Query;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="communityDao")
public class CommunityDaoHibernate
extends AbstractCommonDao<Community>
implements CommunityDao {
    public CommunityDaoHibernate() {
        super(Community.class);
    }

    @Override
    public Optional<Community> find(CommunityReference reference) {
        Query query = this.getSessionFactory().getCurrentSession().createQuery("from Community c left join fetch c.users where c.reference.shortName = :shortName", Community.class).setParameter("shortName", (Object)reference.getShortName());
        return CommunityDaoHibernate.singleResult(query);
    }

    @Override
    public List<Community> find(String name) {
        return this.getSessionFactory().getCurrentSession().createQuery("from Community c left join fetch c.users where c.name = :name", Community.class).setParameter("name", (Object)name).getResultList();
    }

    @Override
    public Page<Community> findAll(CommunityFilter communityFilter, Pageable pageable) {
        long total = this.countAll();
        Optional<Object> sqlsort = Optional.empty();
        if (pageable.getSort().isSorted()) {
            sqlsort = Optional.of("ORDER BY " + pageable.getSort().stream().map(s -> s.getProperty().equals("shortName") ? "reference.shortName" : s.getProperty() + " " + s.getDirection().name()).collect(Collectors.joining(", ")));
        }
        Query communityQuery = this.getSessionFactory().getCurrentSession().createQuery("FROM  Community c WHERE " + FilterBuilder.filter("shortName", "c.reference.shortName") + " AND " + FilterBuilder.filter("name", "c.name") + sqlsort.orElse(""), Community.class).setParameter("shortName", (Object)communityFilter.getShortName()).setParameter("name", (Object)communityFilter.getName());
        if (pageable.isPaged()) {
            communityQuery.setFirstResult((int)pageable.getOffset());
            communityQuery.setMaxResults(pageable.getPageSize());
        } else {
            communityQuery.setFetchSize(0);
            communityQuery.setMaxResults(Integer.MAX_VALUE);
        }
        List communities = communityQuery.getResultList();
        return new PageImpl(communities, pageable, total);
    }

    private long countAll() {
        return (Long)this.getSessionFactory().getCurrentSession().createQuery("select count(*) from Community c", Long.class).getSingleResult();
    }

    @Override
    public boolean hasMembers(CommunityReference community) {
        return !this.findMembers(community).getUsers().isEmpty();
    }

    @Override
    public Community findMembers(CommunityReference community) {
        return (Community)this.getSessionFactory().getCurrentSession().createQuery("from Community c left join fetch c.users where c.reference.shortName = :communityShortName", Community.class).setParameter("communityShortName", (Object)community.getShortName()).getSingleResult();
    }

    @Override
    public List<Community> find(SeasonReference seasonReference) {
        return this.getSessionFactory().getCurrentSession().createQuery("from Community c where c.season.reference.name = :name       and c.season.reference.year = :year", Community.class).setParameter("name", (Object)seasonReference.getName()).setParameter("year", (Object)seasonReference.getYear()).getResultList();
    }
}

