/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.storage;

import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import org.apache.commons.lang3.StringUtils;

@Embeddable
public class Nickname
implements Comparable<Nickname> {
    @Column(name="bo_nickname")
    private String nickname;

    protected Nickname() {
    }

    private Nickname(String nickname) {
        this.nickname = nickname;
    }

    public static Nickname of(String nickname) {
        if (StringUtils.isBlank((CharSequence)nickname)) {
            throw new IllegalArgumentException("A nickname must be defined.");
        }
        return new Nickname(nickname);
    }

    public String getNickname() {
        return this.nickname;
    }

    public String value() {
        return this.nickname;
    }

    public void setNickname(String value) {
        this.nickname = value;
    }

    public String toLowerCase() {
        return this.nickname.toLowerCase();
    }

    @Override
    public int compareTo(Nickname o) {
        return this.nickname.toLowerCase().compareTo(o.nickname.toLowerCase());
    }

    public String toString() {
        return "Nickname=[" + this.nickname + "]";
    }

    public int hashCode() {
        return Objects.hash(this.nickname.toLowerCase());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Nickname other = (Nickname)obj;
        return StringUtils.equalsIgnoreCase((CharSequence)this.nickname, (CharSequence)other.nickname);
    }
}

