/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.storage;

import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.validation.constraints.NotNull;

@Embeddable
public class SeasonReference {
    @NotNull
    @Column(name="bo_year")
    private String year;
    @NotNull
    @Column(name="bo_name")
    private String name;

    protected SeasonReference() {
    }

    private SeasonReference(String year, String name) {
        this.year = year;
        this.name = name;
    }

    public static SeasonReference of(String year, String name) {
        return new SeasonReference(year, name);
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String value) {
        Objects.nonNull(value);
        this.year = value.trim();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        Objects.nonNull(value);
        this.name = value.trim();
    }

    public int hashCode() {
        return Objects.hash(this.name, this.year);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SeasonReference other = (SeasonReference)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.year, other.year);
    }

    public String toString() {
        return "SeasonReference [year=" + this.year + ", name=" + this.name + "]";
    }
}

