/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.dao.hibernate;

import de.winkler.betoffice.dao.CommonDao;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Optional;
import javax.persistence.NoResultException;
import org.apache.commons.io.IOUtils;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public abstract class AbstractCommonDao<T>
implements CommonDao<T> {
    private final Class<T> t;
    private SessionFactory sessionFactory;

    @Autowired
    public void setSessionFactory(SessionFactory _sessionFactory) {
        this.sessionFactory = _sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    AbstractCommonDao(Class<T> _t) {
        this.t = _t;
    }

    @Override
    public final T findById(long id) {
        return (T)this.getSessionFactory().getCurrentSession().get(this.t, (Serializable)Long.valueOf(id));
    }

    @Override
    public final void delete(T t) {
        this.getSessionFactory().getCurrentSession().delete(t);
    }

    @Override
    public final void deleteAll(List<T> ts) {
        Session session = this.getSessionFactory().getCurrentSession();
        for (T t : ts) {
            session.delete(t);
        }
    }

    @Override
    public final T save(T t) {
        this.getSessionFactory().getCurrentSession().saveOrUpdate(t);
        return t;
    }

    @Override
    public final void saveAll(List<T> ts) {
        Session session = this.getSessionFactory().getCurrentSession();
        for (T t : ts) {
            session.saveOrUpdate(t);
        }
    }

    @Override
    public final void update(T t) {
        this.getSessionFactory().getCurrentSession().saveOrUpdate(t);
    }

    @Override
    public final void updateAll(List<T> ts) {
        Session session = this.getSessionFactory().getCurrentSession();
        for (T t : ts) {
            session.saveOrUpdate(t);
        }
    }

    @Override
    public final void refresh(T t) {
        this.getSessionFactory().getCurrentSession().refresh(t);
    }

    protected final T first(List<T> objects) {
        if (objects.size() == 0) {
            return null;
        }
        return objects.get(0);
    }

    public static final String loadQuery(String query) {
        try {
            return IOUtils.toString((InputStream)AbstractCommonDao.class.getResourceAsStream(query), (Charset)Charset.forName("UTF-8"));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    static <T> Optional<T> singleResult(Query<T> query) {
        Optional<Object> optionalResult = null;
        try {
            Object result = query.getSingleResult();
            optionalResult = Optional.of(result);
        }
        catch (NoResultException ex) {
            optionalResult = Optional.empty();
        }
        return optionalResult;
    }

    static <T> Optional<T> singleResult(List<T> list) {
        Optional optionalResult = Optional.empty();
        if (list.size() > 0) {
            optionalResult = Optional.of(list.get(0));
        }
        return optionalResult;
    }
}

