/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.service;

import de.winkler.betoffice.dao.SessionDao;
import de.winkler.betoffice.dao.UserDao;
import de.winkler.betoffice.service.AuthService;
import de.winkler.betoffice.service.DateTimeProvider;
import de.winkler.betoffice.service.SecurityToken;
import de.winkler.betoffice.storage.Nickname;
import de.winkler.betoffice.storage.Session;
import de.winkler.betoffice.storage.User;
import de.winkler.betoffice.storage.enums.RoleType;
import de.winkler.betoffice.util.LoggerFactory;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="authService")
public class DefaultAuthService
implements AuthService {
    private final Logger log = LoggerFactory.make();
    @Autowired
    private UserDao userDao;
    @Autowired
    private SessionDao sessionDao;
    @Autowired
    private DateTimeProvider dateTimeProvider;

    @Override
    @Transactional
    public SecurityToken login(Nickname name, String password, String sessionId, String address, String browserId) {
        Optional<User> user = this.userDao.findByNickname(name);
        SecurityToken securityToken = null;
        if (user.isPresent() && user.get().comparePwd(password)) {
            User presentUser = user.get();
            ArrayList<RoleType> roleTypes = new ArrayList<RoleType>();
            if (presentUser.isAdmin()) {
                roleTypes.add(RoleType.ADMIN);
            }
            if (!presentUser.isExcluded()) {
                roleTypes.add(RoleType.TIPPER);
            }
            ZonedDateTime now = this.dateTimeProvider.currentDateTime();
            securityToken = new SecurityToken(sessionId, presentUser, roleTypes, now);
            Session session = new Session();
            session.setBrowser(browserId);
            session.setFailedLogins(0);
            session.setLogin(now);
            session.setLogout(null);
            session.setNickname(name.getNickname());
            session.setRemoteAddress(address);
            session.setToken(securityToken.getToken());
            session.setUser(user.get());
            this.sessionDao.save(session);
        }
        return securityToken;
    }

    @Override
    @Transactional
    public Optional<SecurityToken> findTokenByNickname(Nickname nickname) {
        return this.findTokenByNickname(nickname);
    }

    @Override
    @Transactional
    public void logout(SecurityToken securityToken) {
        List<Session> sessions = this.sessionDao.findBySessionId(securityToken.getToken());
        if (sessions.isEmpty()) {
            this.log.warn("Trying to logout with an invalid securityToken=[{}]", (Object)securityToken);
        } else {
            for (Session session : sessions) {
                session.setLogout(this.dateTimeProvider.currentDateTime());
                this.sessionDao.save(session);
            }
        }
    }

    @Override
    public Optional<Session> validateSession(String token) {
        List<Session> sessions = this.sessionDao.findBySessionId(token);
        if (sessions.isEmpty()) {
            this.log.warn("Trying to validate the session with an invalid securityToken=[{}]", (Object)token);
            return Optional.empty();
        }
        Session session = sessions.get(0);
        session.getUser().getNickname();
        return Optional.of(session);
    }

    @Override
    public Optional<User> findByNickname(Nickname nickname) {
        return this.userDao.findByNickname(nickname);
    }
}

