/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.storage;

import de.winkler.betoffice.storage.AbstractStorageObject;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;

@Entity
@Table(name="bo_grouptype")
public class GroupType
extends AbstractStorageObject
implements Comparable<GroupType> {
    private static final long serialVersionUID = -8513852915020891940L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", updatable=false, nullable=false)
    private Long id;
    @NotNull
    @Column(name="bo_name")
    private String name;

    public static GroupType of(String groupTypeName) {
        GroupType groupType = new GroupType();
        groupType.setName(groupTypeName);
        return groupType;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    protected void setId(Long value) {
        this.id = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public boolean isValid() {
        return !StringUtils.isBlank((CharSequence)this.name);
    }

    @Override
    public int compareTo(GroupType o) {
        return this.getName().compareTo(o.getName());
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof GroupType)) {
            return false;
        }
        GroupType groupType = (GroupType)object;
        return groupType.getName().equals(this.getName());
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getName().hashCode();
        return result;
    }
}

