/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.storage;

import de.winkler.betoffice.storage.AbstractStorageObject;
import de.winkler.betoffice.storage.ChampionshipConfiguration;
import de.winkler.betoffice.storage.GameList;
import de.winkler.betoffice.storage.Group;
import de.winkler.betoffice.storage.GroupType;
import de.winkler.betoffice.storage.SeasonReference;
import de.winkler.betoffice.storage.Team;
import de.winkler.betoffice.storage.enums.SeasonType;
import de.winkler.betoffice.storage.enums.TeamType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import org.apache.commons.lang3.Validate;
import org.joda.time.DateTime;

@Entity
@Table(name="bo_season")
public class Season
extends AbstractStorageObject {
    private static final long serialVersionUID = -8992251563826611291L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", updatable=false, nullable=false)
    private Long id;
    @Embedded
    private SeasonReference reference = new SeasonReference();
    @Embedded
    private ChampionshipConfiguration championshipConfiguration = new ChampionshipConfiguration();
    @Enumerated
    @Column(name="bo_mode")
    private SeasonType mode = SeasonType.LEAGUE;
    @Enumerated
    @Column(name="bo_teamtype")
    private TeamType teamType = TeamType.DFB;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="bo_season_ref")
    private Set<Group> groups = new HashSet<Group>();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="bo_season_ref")
    @OrderColumn(name="bo_index")
    private List<GameList> gameList = new ArrayList<GameList>();

    public Season() {
    }

    public Season(SeasonReference sr) {
        this.reference = sr;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    protected void setId(Long value) {
        this.id = value;
    }

    public SeasonReference getReference() {
        return this.reference;
    }

    public void setReference(SeasonReference reference) {
        this.reference = reference;
    }

    public ChampionshipConfiguration getChampionshipConfiguration() {
        if (this.championshipConfiguration == null) {
            this.championshipConfiguration = new ChampionshipConfiguration();
        }
        return this.championshipConfiguration;
    }

    protected void setChampionshipConfiguration(ChampionshipConfiguration value) {
        this.championshipConfiguration = value;
    }

    public SeasonType getMode() {
        return this.mode;
    }

    public void setMode(SeasonType value) {
        this.mode = value;
    }

    public TeamType getTeamType() {
        return this.teamType;
    }

    public void setTeamType(TeamType value) {
        this.teamType = value;
    }

    public Set<Group> getGroups() {
        return this.groups;
    }

    protected void setGroups(Set<Group> value) {
        this.groups = value;
    }

    public Group getGroup(GroupType groupType) {
        for (Group group : this.getGroups()) {
            if (!group.getGroupType().equals(groupType)) continue;
            return group;
        }
        return null;
    }

    public void addGroup(Group group) {
        Validate.notNull((Object)group);
        group.setSeason(this);
        this.groups.add(group);
    }

    public void addGroups(Set<Group> values) {
        Validate.notNull(values);
        for (Group group : values) {
            this.addGroup(group);
        }
    }

    public void removeGroup(Group group) {
        Validate.notNull((Object)group.getSeason());
        Validate.isTrue((boolean)group.getSeason().equals(this));
        this.groups.remove(group);
    }

    public Group removeGroup(GroupType groupType) {
        Iterator<Group> i = this.getGroups().iterator();
        while (i.hasNext()) {
            Group tmp = i.next();
            if (!tmp.getGroupType().equals(groupType)) continue;
            i.remove();
            return tmp;
        }
        return null;
    }

    public Set<Team> getTeams() {
        HashSet<Team> teams = new HashSet<Team>();
        for (Group group : this.getGroups()) {
            teams.addAll(group.getTeams());
        }
        return teams;
    }

    public List<GroupType> getGroupTypes() {
        ArrayList<GroupType> result = new ArrayList<GroupType>();
        for (Group group : this.getGroups()) {
            result.add(group.getGroupType());
        }
        return result;
    }

    protected List<GameList> getGameList() {
        return this.gameList;
    }

    protected void setGameList(List<GameList> value) {
        Validate.notNull(value);
        this.gameList = value;
    }

    public List<GameList> toGameList() {
        return Collections.unmodifiableList(this.gameList);
    }

    public List<GameList> toGameList(Predicate<GameList> filter) {
        return this.gameList.stream().filter(filter).collect(Collectors.toList());
    }

    public int size() {
        return this.gameList.size();
    }

    public int indexOf(Object object) {
        return this.gameList.indexOf(object);
    }

    public boolean contains(GameList _gameList) {
        return this.gameList.contains(_gameList);
    }

    public GameList getGamesOfDay(int dayNr) {
        if (dayNr >= this.gameList.size() || dayNr < 0) {
            throw new IndexOutOfBoundsException("dayNr '" + dayNr + "' out of bounds!");
        }
        if (this.gameList.size() == 0) {
            return null;
        }
        for (GameList currGameList : this.gameList) {
            if (currGameList.getIndex() == -1) {
                String dateTime = new DateTime((Object)currGameList.getDateTime()).toString("dd.MM.yyyy HH:mm", Locale.GERMANY);
                throw new IllegalStateException("current round index: " + currGameList.getIndex() + "; dateTime: " + dateTime);
            }
            if (currGameList.getIndex() != dayNr) continue;
            return currGameList;
        }
        throw new IllegalStateException();
    }

    public void addGameList(GameList newRound) {
        Validate.notNull((Object)newRound, (String)"The newRound parameter is null.", (Object[])new Object[0]);
        Validate.notNull((Object)newRound.getDateTime(), (String)"The datetime field of newRound is null.", (Object[])new Object[0]);
        Validate.notNull((Object)newRound.getGroup(), (String)"The group field of newRound is null.", (Object[])new Object[0]);
        for (GameList gl : this.getGameList()) {
            if (gl.getDateTime() == null || !gl.getDateTime().equals(newRound.getDateTime()) || !gl.getGroup().equals(newRound.getGroup())) continue;
            String error = String.format("Round [%s] with same date and group is already there.", newRound.toString());
            throw new IllegalArgumentException(error);
        }
        newRound.setSeason(this);
        if (newRound.getIndex() == 0) {
            newRound.setIndex(this.gameList.size());
        }
        this.gameList.add(newRound);
    }

    public void removeAllGameList() {
        ArrayList<GameList> tmp = new ArrayList<GameList>(this.getGameList());
        for (GameList gl : tmp) {
            gl.removeAllGame();
            this.removeGameList(gl);
        }
    }

    public void removeGameList(GameList _gameList) {
        Validate.notNull((Object)_gameList);
        if (!this.gameList.contains(_gameList)) {
            StringBuilder buf = new StringBuilder(_gameList.toString());
            buf.append(" nicht vorhanden!");
            throw new IllegalArgumentException(buf.toString());
        }
        this.gameList.remove(_gameList);
        _gameList.setSeason(null);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Year: ").append(this.getReference().getYear());
        buf.append(", Name: ").append(this.getReference().getName());
        if (this.getMode() == null) {
            buf.append(", Mode:").append("<null>");
        } else {
            buf.append(", Mode:").append(this.getMode().toString());
        }
        return buf.toString();
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Season)) {
            return false;
        }
        Season ssn = (Season)object;
        return this.getReference().equals(ssn.getReference());
    }

    public final int hashCode() {
        return 37;
    }
}

