/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice;

import de.winkler.betoffice.util.LoggerFactory;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class SpringBeans {
    private final Logger log = LoggerFactory.make();
    private final FileSystemXmlApplicationContext applicationContext;

    public SpringBeans(String applicationResource) {
        this(new String[]{applicationResource});
    }

    public SpringBeans(String[] applicationResources) {
        if (this.log.isInfoEnabled()) {
            for (String resource : applicationResources) {
                this.log.info("ApplicationResource..: {}", (Object)resource);
            }
        }
        FileSystemXmlApplicationContext context = null;
        try {
            context = new FileSystemXmlApplicationContext(applicationResources);
        }
        catch (BeansException ex) {
            this.log.error("BeanException", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        this.applicationContext = context;
    }

    protected final FileSystemXmlApplicationContext getBeanFactory() {
        return this.applicationContext;
    }

    public final <T> T getBean(String beanId) {
        return (T)this.getBeanFactory().getBean(beanId);
    }
}

