/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.dao.hibernate;

import de.winkler.betoffice.dao.GoalDao;
import de.winkler.betoffice.dao.hibernate.AbstractCommonDao;
import de.winkler.betoffice.storage.Game;
import de.winkler.betoffice.storage.Goal;
import java.util.List;
import java.util.Optional;
import org.hibernate.query.BindableType;
import org.hibernate.query.Query;
import org.hibernate.type.StandardBasicTypes;
import org.springframework.stereotype.Repository;

@Repository(value="goalDao")
public class GoalDaoHibernate
extends AbstractCommonDao<Goal>
implements GoalDao {
    public GoalDaoHibernate() {
        super(Goal.class);
    }

    @Override
    public List<Goal> findAll() {
        return this.getSessionFactory().getCurrentSession().createQuery("select goal from Goal goal inner join fetch goal.player order by goal.id", Goal.class).getResultList();
    }

    @Override
    public Optional<Goal> findByOpenligaid(long openligaid) {
        Query query = this.getSessionFactory().getCurrentSession().createQuery("select goal from Goal goal where goal.openligaid = :openligaid", Goal.class).setParameter("openligaid", (Object)openligaid, (BindableType)StandardBasicTypes.LONG);
        return GoalDaoHibernate.singleResult(query);
    }

    @Override
    public List<Goal> find(Game match) {
        return this.find(match.getId());
    }

    @Override
    public List<Goal> find(long matchId) {
        List goals = this.getSessionFactory().getCurrentSession().createQuery("select goal from Goal goal where goal.game.id = :matchId order by goal.minute", Goal.class).setParameter("matchId", (Object)matchId, (BindableType)StandardBasicTypes.LONG).getResultList();
        return goals;
    }

    @Override
    public void deleteAll(Game game) {
        this.getSessionFactory().getCurrentSession().createMutationQuery("delete from Goal g where g.game = :game");
    }
}

