/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.service;

import de.winkler.betoffice.storage.Game;
import de.winkler.betoffice.storage.GameList;
import de.winkler.betoffice.storage.GameResult;
import de.winkler.betoffice.storage.GameTipp;
import de.winkler.betoffice.storage.Goal;
import de.winkler.betoffice.storage.Group;
import de.winkler.betoffice.storage.GroupType;
import de.winkler.betoffice.storage.Player;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.Team;
import de.winkler.betoffice.storage.TeamResult;
import de.winkler.betoffice.storage.User;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public interface SeasonManagerService {
    public List<TeamResult> calculateTeamRanking(Season var1, GroupType var2);

    public List<TeamResult> calculateTeamRanking(Season var1, GroupType var2, int var3, int var4);

    public List<Season> findAllSeasons();

    public List<Goal> findAllGoals();

    public List<Team> findTeams(Group var1);

    public List<Team> findTeams(Season var1, GroupType var2);

    public Optional<Season> findSeasonByName(String var1, String var2);

    public Season findSeasonById(long var1);

    public Optional<GameList> findRound(Season var1, int var2);

    public Optional<GameList> findLastRound(Season var1);

    public Optional<GameList> findFirstRound(Season var1);

    public GameList findRound(long var1);

    public Optional<GameList> findRoundGames(long var1);

    public Optional<GameList> findNextRound(long var1);

    public Optional<GameList> findPrevRound(long var1);

    public List<GameList> findRounds(Season var1);

    public List<GameList> findRounds(Group var1);

    public List<GameTipp> findTippsByMatch(Game var1);

    public List<GameTipp> findTipps(GameList var1, User var2);

    public List<Group> findGroups(Season var1);

    public List<GroupType> findGroupTypes(Season var1);

    public Group findGroup(Season var1, GroupType var2);

    public List<GroupType> findGroupTypesBySeason(Season var1);

    public List<Game> findMatches(Team var1, Team var2);

    public List<Game> findMatches(GameList var1);

    public Game findMatch(Long var1);

    public Optional<Game> findMatch(GameList var1, Team var2, Team var3);

    public List<Game> findMatches(Team var1, Team var2, boolean var3);

    public List<Goal> findGoalsOfMatch(Game var1);

    public Optional<Player> findGoalsOfPlayer(long var1);

    public Season createSeason(Season var1);

    public void deleteSeason(Season var1);

    public void updateSeason(Season var1);

    public Season addGroupType(Season var1, GroupType var2);

    public void addGroupType(Season var1, Collection<GroupType> var2);

    public void removeGroupType(Season var1, GroupType var2);

    public void removeGroupType(Season var1, Collection<GroupType> var2);

    public Group addTeam(Season var1, GroupType var2, Team var3);

    public Group addTeams(Season var1, GroupType var2, Collection<Team> var3);

    public void removeTeam(Season var1, GroupType var2, Team var3);

    public void removeTeams(Season var1, GroupType var2, Collection<Team> var3);

    public GameList addRound(Season var1, ZonedDateTime var2, GroupType var3);

    public void removeRound(Season var1, GameList var2);

    public Game addMatch(GameList var1, ZonedDateTime var2, Group var3, Team var4, Team var5);

    public Game addMatch(GameList var1, ZonedDateTime var2, Group var3, Team var4, Team var5, GameResult var6);

    public Game addMatch(GameList var1, ZonedDateTime var2, Group var3, Team var4, Team var5, int var6, int var7);

    public Game addMatch(Season var1, int var2, ZonedDateTime var3, GroupType var4, Team var5, Team var6);

    public Game addMatch(Season var1, int var2, ZonedDateTime var3, GroupType var4, Team var5, Team var6, int var7, int var8);

    public void updateMatch(Game var1);

    public void updateMatch(Collection<Game> var1);

    public GameList addRound(Season var1, int var2, ZonedDateTime var3, GroupType var4);

    public GameList updateRound(Season var1, int var2, ZonedDateTime var3, GroupType var4);

    public void removeMatch(Game var1);

    public void addGoal(Game var1, Goal var2);
}

