/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.validation;

import de.winkler.betoffice.validation.BetofficeServiceResult;
import de.winkler.betoffice.validation.BetofficeValidationMessage;
import java.util.Optional;

class DefaultBetofficeServiceResult<T>
implements BetofficeServiceResult<T> {
    private final T result;
    private final BetofficeValidationMessage validationMessage;

    private DefaultBetofficeServiceResult() {
        this.result = null;
        this.validationMessage = BetofficeValidationMessage.error();
    }

    private DefaultBetofficeServiceResult(T result) {
        this.result = result;
        this.validationMessage = BetofficeValidationMessage.ok();
    }

    @Override
    public Optional<T> result() {
        return Optional.ofNullable(this.result);
    }

    @Override
    public BetofficeValidationMessage message() {
        return this.validationMessage;
    }

    static <T> BetofficeServiceResult<T> sucess(T result) {
        return new DefaultBetofficeServiceResult<T>(result);
    }

    static <T> BetofficeServiceResult<T> failure() {
        return new DefaultBetofficeServiceResult<T>();
    }

    static <T> BetofficeServiceResult<T> failure(BetofficeValidationMessage.ErrorType errorType) {
        return new DefaultBetofficeServiceResult<T>();
    }
}

