/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.dao.hibernate;

import de.winkler.betoffice.dao.MatchDao;
import de.winkler.betoffice.dao.hibernate.AbstractCommonDao;
import de.winkler.betoffice.storage.Game;
import de.winkler.betoffice.storage.GameList;
import de.winkler.betoffice.storage.Team;
import jakarta.persistence.TypedQuery;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Repository;

@Repository(value="matchDao")
public class MatchDaoHibernate
extends AbstractCommonDao<Game>
implements MatchDao {
    private static final String QUERY_MATCHES_BY_HOME_TEAM = "select\n    match\nfrom\n    Game as match\nwhere\n    match.homeTeam.id = :homeTeamId\norder by\n    match.dateTime desc\n";
    private static final String QUERY_MATCHES_BY_GUEST_TEAM = "select\n    match\nfrom\n    Game as match\nwhere\n    match.guestTeam.id = :guestTeamId\norder by\n    match.dateTime desc\n";
    private static final String QUERY_MATCHES_BY_HOME_AND_GUEST_TEAM = "select\n    match\nfrom\n    Game as match\n    left join fetch match.goals\n    left join fetch match.location\nwhere\n    match.homeTeam.id = :homeTeamId\n    and match.guestTeam.id = :guestTeamId\norder by\n    match.dateTime desc\n";
    private static final String QUERY_MATCHES_BY_HOME_AND_GUEST_TEAM_AND_REVERSE = "select\n    match\nfrom\n    Game as match\n    left join fetch match.goals\n    left join fetch match.location\nwhere\n    (\n        match.homeTeam.id = :homeTeamId\n        and match.guestTeam.id = :guestTeamId\n    )\n    or\n    (\n        match.homeTeam.id = :guestTeamId\n        and match.guestTeam.id = :homeTeamId\n    )\norder by\n    match.dateTime desc\n";
    private static final String QUERY_MATCHES_BY_TEAM = "select\n    match\nfrom\n    Game as match\n    left join fetch match.goals\n    left join fetch match.location\nwhere\n    match.homeTeam.id = :teamId\n    or match.guestTeam.id = :teamId\norder by\n    match.dateTime desc\n";
    private static final String QUERY_MATCH_BY_HOME_AND_GUEST_TEAM_AND_ROUND = "select\n    match\nfrom\n    Game as match\nwhere\n    match.homeTeam.id = :homeTeamId\n    and match.guestTeam.id = :guestTeamId\n    and match.gameList.id = :gameListId\n";

    public MatchDaoHibernate() {
        super(Game.class);
    }

    @Override
    public List<Game> findByHomeTeam(Team homeTeam, int limit) {
        List games = this.getEntityManager().createQuery(QUERY_MATCHES_BY_HOME_TEAM, Game.class).setParameter("homeTeamId", (Object)homeTeam.getId()).setMaxResults(limit).getResultList();
        return games;
    }

    @Override
    public List<Game> findByGuestTeam(Team guestTeam, int limit) {
        List games = this.getEntityManager().createQuery(QUERY_MATCHES_BY_GUEST_TEAM, Game.class).setParameter("guestTeamId", (Object)guestTeam.getId()).setMaxResults(limit).getResultList();
        return games;
    }

    @Override
    public List<Game> find(Team homeTeam, Team guestTeam, int limit) {
        List games = this.getEntityManager().createQuery(QUERY_MATCHES_BY_HOME_AND_GUEST_TEAM, Game.class).setParameter("homeTeamId", (Object)homeTeam.getId()).setParameter("guestTeamId", (Object)guestTeam.getId()).setMaxResults(limit).getResultList();
        return games;
    }

    @Override
    public List<Game> findAll(Team homeTeam, Team guestTeam, int limit) {
        List games = this.getEntityManager().createQuery(QUERY_MATCHES_BY_HOME_AND_GUEST_TEAM_AND_REVERSE, Game.class).setParameter("homeTeamId", (Object)homeTeam.getId()).setParameter("guestTeamId", (Object)guestTeam.getId()).setMaxResults(limit).getResultList();
        return games;
    }

    @Override
    public List<Game> find(Team team, int limit) {
        List games = this.getEntityManager().createQuery(QUERY_MATCHES_BY_TEAM, Game.class).setParameter("teamId", (Object)team.getId()).setMaxResults(limit).getResultList();
        return games;
    }

    @Override
    public Optional<Game> find(GameList round, Team homeTeam, Team guestTeam) {
        TypedQuery query = this.getEntityManager().createQuery(QUERY_MATCH_BY_HOME_AND_GUEST_TEAM_AND_ROUND, Game.class).setParameter("homeTeamId", (Object)homeTeam.getId()).setParameter("guestTeamId", (Object)guestTeam.getId()).setParameter("gameListId", (Object)round.getId());
        return MatchDaoHibernate.singleResult(query);
    }

    @Override
    public List<Game> find(GameList round) {
        TypedQuery query = this.getEntityManager().createQuery("from Game g where g.gameList.id = :roundId", Game.class).setParameter("roundId", (Object)round.getId());
        return query.getResultList();
    }
}

