/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.dao.hibernate;

import de.winkler.betoffice.dao.SeasonDao;
import de.winkler.betoffice.dao.hibernate.AbstractCommonDao;
import de.winkler.betoffice.storage.GroupType;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.SeasonReference;
import de.winkler.betoffice.storage.Team;
import de.winkler.betoffice.storage.TeamResult;
import de.winkler.betoffice.storage.comparator.TeamPointsComparator;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.type.StandardBasicTypes;
import org.springframework.stereotype.Repository;

@Repository(value="seasonDao")
public class SeasonDaoHibernate
extends AbstractCommonDao<Season>
implements SeasonDao {
    private static final String QUERY_SEASON_BY_NAME_AND_YEAR = "select season from " + Season.class.getName() + " as season where season.reference.name = :name and season.reference.year = :year";
    private static final String QUERY_TEAM_SEASON_GOALS = AbstractCommonDao.loadQuery("query_teamresult_season_goals.sql");
    private static final String QUERY_TEAM_SEASON_POINTS = AbstractCommonDao.loadQuery("query_teamresult_season_points.sql");
    private static final String QUERY_TEAM_SEASON_RANGE_GOALS = AbstractCommonDao.loadQuery("query_teamresult_season_range_goals.sql");
    private static final String QUERY_TEAM_SEASON_RANGE_POINTS = AbstractCommonDao.loadQuery("query_teamresult_season_range_points.sql");

    public SeasonDaoHibernate() {
        super(Season.class);
    }

    @Override
    public List<Season> findAll() {
        List seasons = this.getEntityManager().createQuery("select s from Season s order by s.reference.year", Season.class).getResultList();
        return seasons;
    }

    @Override
    public Optional<Season> find(SeasonReference seasonRef) {
        TypedQuery query = this.getEntityManager().createQuery(QUERY_SEASON_BY_NAME_AND_YEAR, Season.class).setParameter("name", (Object)seasonRef.getName()).setParameter("year", (Object)seasonRef.getYear());
        return SeasonDaoHibernate.singleResult(query);
    }

    @Override
    public List<TeamResult> calculateTeamRanking(Season season, GroupType groupType) {
        HashMap<Team, TeamResult> resultMap = new HashMap<Team, TeamResult>();
        NativeQuery queryTeamGoals = ((Session)this.getEntityManager().unwrap(Session.class)).createNativeQuery(QUERY_TEAM_SEASON_GOALS).addEntity("team", Team.class).addScalar("diff", StandardBasicTypes.LONG).addScalar("pos_goals", StandardBasicTypes.LONG).addScalar("neg_goals", StandardBasicTypes.LONG);
        queryTeamGoals.setParameter("season_id", (Object)season.getId());
        queryTeamGoals.setParameter("grouptype_id", (Object)groupType.getId());
        List resultQueryTeamGoals = queryTeamGoals.list();
        for (Object object : resultQueryTeamGoals) {
            Object[] row = (Object[])object;
            Team team = (Team)row[0];
            int posGoals = ((Long)row[2]).intValue();
            int negGoals = ((Long)row[3]).intValue();
            TeamResult tr = new TeamResult(season, groupType, team);
            tr.setNegGoals(negGoals);
            tr.setPosGoals(posGoals);
            resultMap.put(team, tr);
        }
        NativeQuery queryTeamPoints = ((Session)this.getEntityManager().unwrap(Session.class)).createNativeQuery(QUERY_TEAM_SEASON_POINTS).addEntity("team", Team.class).addScalar("win", StandardBasicTypes.LONG).addScalar("remis", StandardBasicTypes.LONG).addScalar("lost", StandardBasicTypes.LONG).addScalar("points", StandardBasicTypes.LONG);
        queryTeamPoints.setParameter("season_id", (Object)season.getId());
        queryTeamPoints.setParameter("grouptype_id", (Object)groupType.getId());
        List resultQueryTeamPoints = queryTeamPoints.getResultList();
        for (Object object : resultQueryTeamPoints) {
            TeamResult tr;
            Object[] row = (Object[])object;
            Team team = (Team)row[0];
            int win = ((Long)row[1]).intValue();
            int remis = ((Long)row[2]).intValue();
            int lost = ((Long)row[3]).intValue();
            if (resultMap.containsKey(team)) {
                tr = (TeamResult)resultMap.get(team);
                tr.setWin(win);
                tr.setLost(lost);
                tr.setRemis(remis);
                continue;
            }
            tr = new TeamResult(season, groupType, team);
            tr.setWin(win);
            tr.setLost(lost);
            tr.setRemis(remis);
            resultMap.put(team, tr);
        }
        return this.teamResultToList(resultMap);
    }

    @Override
    public List<TeamResult> calculateTeamRanking(Season season, GroupType groupType, int startIndex, int endIndex) {
        HashMap<Team, TeamResult> resultMap = new HashMap<Team, TeamResult>();
        NativeQuery queryTeamGoals = ((Session)this.getEntityManager().unwrap(Session.class)).createNativeQuery(QUERY_TEAM_SEASON_RANGE_GOALS).addEntity("team", Team.class).addScalar("diff", StandardBasicTypes.LONG).addScalar("pos_goals", StandardBasicTypes.LONG).addScalar("neg_goals", StandardBasicTypes.LONG);
        queryTeamGoals.setParameter("season_id", (Object)season.getId());
        queryTeamGoals.setParameter("grouptype_id", (Object)groupType.getId());
        queryTeamGoals.setParameter("start_index", (Object)startIndex);
        queryTeamGoals.setParameter("end_index", (Object)endIndex);
        List resultQueryTeamGoals = queryTeamGoals.getResultList();
        for (Object object : resultQueryTeamGoals) {
            Object[] row = (Object[])object;
            Team team = (Team)row[0];
            int posGoals = ((Long)row[2]).intValue();
            int negGoals = ((Long)row[3]).intValue();
            TeamResult tr = new TeamResult(season, groupType, team);
            tr.setNegGoals(negGoals);
            tr.setPosGoals(posGoals);
            resultMap.put(team, tr);
        }
        NativeQuery queryTeamPoints = ((Session)this.getEntityManager().unwrap(Session.class)).createNativeQuery(QUERY_TEAM_SEASON_RANGE_POINTS).addEntity("team", Team.class).addScalar("win", StandardBasicTypes.LONG).addScalar("remis", StandardBasicTypes.LONG).addScalar("lost", StandardBasicTypes.LONG).addScalar("points", StandardBasicTypes.LONG);
        queryTeamPoints.setParameter("season_id", (Object)season.getId());
        queryTeamPoints.setParameter("grouptype_id", (Object)groupType.getId());
        queryTeamPoints.setParameter("start_index", (Object)startIndex);
        queryTeamPoints.setParameter("end_index", (Object)endIndex);
        List resultQueryTeamPoints = queryTeamPoints.getResultList();
        for (Object object : resultQueryTeamPoints) {
            TeamResult tr;
            Object[] row = (Object[])object;
            Team team = (Team)row[0];
            int win = ((Long)row[1]).intValue();
            int remis = ((Long)row[2]).intValue();
            int lost = ((Long)row[3]).intValue();
            if (resultMap.containsKey(team)) {
                tr = (TeamResult)resultMap.get(team);
                tr.setWin(win);
                tr.setLost(lost);
                tr.setRemis(remis);
                continue;
            }
            tr = new TeamResult(season, groupType, team);
            tr.setWin(win);
            tr.setLost(lost);
            tr.setRemis(remis);
            resultMap.put(team, tr);
        }
        return this.teamResultToList(resultMap);
    }

    private List<TeamResult> teamResultToList(Map<Team, TeamResult> teamResults) {
        ArrayList<TeamResult> tr = new ArrayList<TeamResult>();
        tr.addAll(teamResults.values());
        Collections.sort(tr, new TeamPointsComparator());
        for (int i = 0; i < tr.size(); ++i) {
            ((TeamResult)tr.get(i)).setTabPos(i + 1);
        }
        return tr;
    }
}

