/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.mail;

import de.winkler.betoffice.mail.MailTask;
import de.winkler.betoffice.service.CommunityService;
import de.winkler.betoffice.service.TippService;
import de.winkler.betoffice.storage.GameList;
import de.winkler.betoffice.storage.GameTipp;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.User;
import de.winkler.betoffice.storage.enums.NotificationType;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SendReminderMailNotification {
    private static final Logger LOG = LoggerFactory.getLogger(SendReminderMailNotification.class);
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-dd-MM HH:mm");
    private final TippService tippService;
    private final CommunityService communityService;
    private final MailTask mailTask;

    public SendReminderMailNotification(TippService tippService, CommunityService communityService, MailTask mailTask) {
        this.tippService = tippService;
        this.communityService = communityService;
        this.mailTask = mailTask;
    }

    public void send() {
        ZonedDateTime now = ZonedDateTime.now();
        LocalDate localNow = now.toLocalDate();
        Optional<GameList> nextTippRound = this.tippService.findNextTippRound(now);
        nextTippRound.ifPresent(nxtr -> {
            Season season = ((GameList)nextTippRound.get()).getSeason();
            Set<User> members = this.communityService.findMembers(CommunityService.defaultPlayerGroup(season.getReference()));
            members.stream().filter(SendReminderMailNotification::notify).forEach(u -> {
                try {
                    List<GameTipp> tipps = this.tippService.findTipps((GameList)nxtr, (User)u);
                    ArrayList<GameTipp> sortedTipps = new ArrayList<GameTipp>(tipps);
                    sortedTipps.sort(new Comparator<GameTipp>(this){

                        @Override
                        public int compare(GameTipp o1, GameTipp o2) {
                            return o1.getGame().getDateTime().compareTo(o2.getGame().getDateTime());
                        }
                    });
                    if (!sortedTipps.isEmpty() && ((GameTipp)sortedTipps.get(0)).getGame().getDateTime().toLocalDate().compareTo(localNow) == 0) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("Heute ist Spieltag. Vergiss deinen Tipp nicht: https://tippdiekistebier.de\n");
                        sb.append("F\u00fcr den aktuellen Spieltag liegen die folgenden Tipps von dir vor:");
                        for (GameTipp userTipp : sortedTipps) {
                            sb.append("\n").append(userTipp.getGame().getDateTime().format(formatter)).append(" ").append(userTipp.getGame().getHomeTeam().getName()).append(" - ").append(userTipp.getGame().getGuestTeam().getName()).append(" ").append(userTipp.getTipp().getHomeGoals()).append(":").append(userTipp.getTipp().getGuestGoals());
                        }
                        this.mailTask.send("betoffice@andre-winkler.de", u.getEmail(), "Spieltag!", sb.toString());
                    }
                }
                catch (Exception ex) {
                    LOG.error(String.format("Unable to send an email to %s", u.getEmail()), (Throwable)ex);
                }
            });
        });
    }

    public static boolean notify(User user) {
        return NotificationType.TIPP.equals((Object)user.getNotification());
    }
}

