/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.service;

import de.winkler.betoffice.dao.CommunityDao;
import de.winkler.betoffice.dao.SeasonDao;
import de.winkler.betoffice.dao.UserDao;
import de.winkler.betoffice.mail.SendUserProfileChangeMailNotification;
import de.winkler.betoffice.service.AbstractManagerService;
import de.winkler.betoffice.service.CommunityService;
import de.winkler.betoffice.storage.Community;
import de.winkler.betoffice.storage.CommunityFilter;
import de.winkler.betoffice.storage.CommunityReference;
import de.winkler.betoffice.storage.Nickname;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.SeasonReference;
import de.winkler.betoffice.storage.User;
import de.winkler.betoffice.storage.enums.NotificationType;
import de.winkler.betoffice.util.LoggerFactory;
import de.winkler.betoffice.validation.BetofficeServiceResult;
import de.winkler.betoffice.validation.BetofficeValidationException;
import de.winkler.betoffice.validation.BetofficeValidationMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="communityService")
@Transactional(readOnly=true)
public class DefaultCommunityService
extends AbstractManagerService
implements CommunityService {
    private static final Logger LOG = LoggerFactory.make();
    private final CommunityDao communityDao;
    private final UserDao userDao;
    private final SeasonDao seasonDao;
    private final SendUserProfileChangeMailNotification sendUserProfileChangeMailNotification;

    public DefaultCommunityService(CommunityDao communityDao, UserDao userDao, SeasonDao seasonDao, SendUserProfileChangeMailNotification sendUserProfileChangeMailNotification) {
        this.communityDao = communityDao;
        this.userDao = userDao;
        this.seasonDao = seasonDao;
        this.sendUserProfileChangeMailNotification = sendUserProfileChangeMailNotification;
    }

    @Override
    public Optional<User> findUser(Nickname nickname) {
        return this.userDao.findByNickname(nickname);
    }

    @Override
    public List<User> findAllUsers() {
        return this.userDao.findAll();
    }

    @Override
    public User findUser(long userId) {
        return (User)this.userDao.findById(userId);
    }

    @Override
    public Optional<User> findUserByChangeToken(String changeToken) {
        return this.userDao.findByChangeToken(changeToken);
    }

    @Override
    public Community find(Long communityId) {
        return (Community)this.communityDao.findById(communityId);
    }

    @Override
    public Optional<Community> find(CommunityReference communityReference) {
        return this.communityDao.find(communityReference);
    }

    @Override
    public List<Community> find(String communityName) {
        return this.communityDao.find(communityName);
    }

    @Override
    public Page<Community> findCommunities(CommunityFilter communityFilter, Pageable pageable) {
        return this.communityDao.findAll(communityFilter, pageable);
    }

    @Override
    public Page<User> findUsers(String nicknameFilter, Pageable pageable) {
        return this.userDao.findAll(nicknameFilter, pageable);
    }

    @Override
    public Set<User> findMembers(CommunityReference communityReference) {
        return this.communityDao.findMembers(communityReference).getUsers();
    }

    @Override
    @Transactional
    public BetofficeServiceResult<Community> create(CommunityReference communityRef, SeasonReference seasonRef, String communityName, String communityYear, Nickname managerNickname) {
        Optional<Community> definedCommunity = this.communityDao.find(communityRef);
        if (definedCommunity.isPresent()) {
            return BetofficeServiceResult.failure(BetofficeValidationMessage.ErrorType.COMMUNITY_EXISTS);
        }
        Season persistedSeason = this.seasonDao.find(seasonRef).orElseThrow(() -> new IllegalArgumentException(String.format("%s does not exist.", seasonRef)));
        User communityManager = this.userDao.findByNickname(managerNickname).orElseThrow(() -> new IllegalArgumentException(String.format("%s does not exist.", managerNickname)));
        Community community = new Community();
        community.setYear(communityYear);
        community.setName(communityName);
        community.setReference(communityRef);
        community.setCommunityManager(communityManager);
        community.setSeason(persistedSeason);
        this.communityDao.persist(community);
        return BetofficeServiceResult.sucess(community);
    }

    @Override
    @Transactional
    public void delete(CommunityReference reference) {
        Community community = this.communityDao.find(reference).orElseThrow();
        if (this.communityDao.hasMembers(reference)) {
            LOG.warn("Unable to delete community '{}'. The Community has members.", (Object)community);
            throw new IllegalArgumentException("Unable to delete community. The Community has members.");
        }
        this.communityDao.delete(community);
    }

    @Override
    @Transactional
    public Community addMember(CommunityReference communityReference, Nickname nickname) {
        Community community = this.communityDao.find(communityReference).orElseThrow();
        User user = this.userDao.findByNickname(nickname).orElseThrow();
        community.addMember(user);
        this.communityDao.update(community);
        return community;
    }

    @Override
    @Transactional
    public Community addMembers(CommunityReference communityReference, Set<Nickname> nicknames) {
        Community community = this.communityDao.find(communityReference).orElseThrow();
        nicknames.stream().map(n -> this.userDao.findByNickname((Nickname)n)).forEach(u -> u.ifPresent(us -> community.addMember((User)us)));
        this.communityDao.update(community);
        return community;
    }

    @Override
    @Transactional
    public Community removeMember(CommunityReference reference, Nickname nickname) {
        User user = this.userDao.findByNickname(nickname).orElseThrow();
        Community community = this.communityDao.find(reference).orElseThrow();
        community.removeMember(user);
        this.communityDao.update(community);
        return community;
    }

    @Override
    @Transactional
    public Community removeMembers(CommunityReference reference, Set<Nickname> nicknames) {
        nicknames.stream().forEach(nickname -> this.removeMember(reference, (Nickname)nickname));
        return this.communityDao.find(reference).orElseThrow();
    }

    @Override
    @Transactional
    public User createUser(User user) {
        ArrayList<BetofficeValidationMessage> messages = new ArrayList<BetofficeValidationMessage>();
        if (user.getNickname() == null || StringUtils.isBlank((CharSequence)user.getNickname().value())) {
            messages.add(new BetofficeValidationMessage("Nickname ist nicht gesetzt.", "nickName", BetofficeValidationMessage.Severity.ERROR));
        }
        if (!messages.isEmpty()) {
            throw new BetofficeValidationException(messages);
        }
        this.userDao.persist(user);
        return user;
    }

    @Override
    @Transactional
    public void deleteUser(Nickname nickname) {
        this.userDao.findByNickname(nickname).ifPresent(u -> this.userDao.delete(u));
    }

    @Override
    @Transactional
    public Optional<User> updateUser(boolean adminOperation, Nickname nickname, String name, String surname, String mail, boolean emailNotification, String phone) {
        return this.userDao.findByNickname(nickname).map(u -> {
            u.setName(name);
            u.setSurname(surname);
            u.setPhone(phone);
            u.setNotification(emailNotification ? NotificationType.TIPP : NotificationType.NONE);
            if (!adminOperation && this.hasUserChangedHisMailAddress((User)u, mail) && u.getChangeSend() < 5) {
                u.setChangeEmail(mail);
                u.setChangeToken(UUID.randomUUID().toString());
                this.sendUserProfileChangeMailNotification.send((User)u);
                u.incrementChangeSend();
            } else {
                u.setEmail(mail);
                u.abortEmailChange();
            }
            return u;
        });
    }

    private boolean hasUserChangedHisMailAddress(User user, String newMailAddress) {
        return !StringUtils.equals((CharSequence)user.getEmail(), (CharSequence)newMailAddress);
    }

    @Override
    @Transactional
    public Optional<User> confirmMailAddressChange(Nickname nickname, String changeToken) {
        return this.userDao.findByNickname(nickname).map(u -> {
            if (!StringUtils.equals((CharSequence)changeToken, (CharSequence)u.getChangeToken())) {
                LOG.warn("Unable to confirm email change. ChangeTokens are different. {} vs {}", (Object)changeToken, (Object)u.getChangeToken());
                throw new IllegalArgumentException("Unable to confirm email change. ChangeTokens are different.");
            }
            u.acceptEmailChange();
            return u;
        });
    }

    @Override
    @Transactional
    public Optional<User> abortMailAddressChange(Nickname nickname) {
        return this.userDao.findByNickname(nickname).map(u -> u.abortEmailChange());
    }

    @Override
    @Transactional
    public Optional<User> resubmitConfirmationMail(Nickname nickname) {
        return this.userDao.findByNickname(nickname).filter(u -> u.getChangeSend() < 5).map(u -> this.sendUserProfileChangeMailNotification.send((User)u));
    }
}

