/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.storage;

import de.winkler.betoffice.storage.AbstractStorageObject;
import de.winkler.betoffice.storage.Location;
import de.winkler.betoffice.storage.enums.TeamType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;

@Entity
@Table(name="bo_team")
public class Team
extends AbstractStorageObject {
    private static final long serialVersionUID = -3181346057831881080L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", updatable=false, nullable=false)
    private Long id;
    @Column(name="bo_name")
    private String name;
    @Column(name="bo_longname")
    private String longName;
    @Column(name="bo_shortname")
    private String shortName;
    @Column(name="bo_xshortname")
    private String xshortName;
    @Column(name="bo_logo")
    private String logo;
    @Column(name="bo_teamtype")
    @Enumerated
    private TeamType teamType = TeamType.DFB;
    @Column(name="bo_openligaid")
    private Long openligaid;
    @ManyToOne
    @JoinColumn(name="bo_location_ref")
    private Location location;

    public Team() {
    }

    public Team(String value) {
        this(value, null, null);
    }

    public Team(String _name, String _longName, String _logo) {
        this.setName(_name);
        this.setLongName(_longName);
        this.setLogo(_logo);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    protected void setId(Long value) {
        this.id = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getLongName() {
        return this.longName;
    }

    public void setLongName(String value) {
        this.longName = value;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String value) {
        this.shortName = value;
    }

    public String getXshortName() {
        return this.xshortName;
    }

    public void setXshortName(String value) {
        this.xshortName = value;
    }

    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String value) {
        this.logo = value;
    }

    public TeamType getTeamType() {
        return this.teamType;
    }

    public void setTeamType(TeamType value) {
        this.teamType = value;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location value) {
        this.location = value;
    }

    public Long getOpenligaid() {
        return this.openligaid;
    }

    public void setOpenligaid(Long value) {
        this.openligaid = value;
    }

    public String toString() {
        return this.longName;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Team)) {
            return false;
        }
        Team team = (Team)object;
        return team.getName().equals(this.getName());
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getName().hashCode();
        return result;
    }

    public static class TeamBuilder {
        private String name;
        private String longName;
        private String logoResource;
        private TeamType teamType;

        public static TeamBuilder team(String name) {
            TeamBuilder tb = new TeamBuilder();
            tb.name = name;
            return tb;
        }

        public TeamBuilder longName(String longName) {
            this.longName = longName;
            return this;
        }

        public TeamBuilder logo(String logoResource) {
            this.logoResource = logoResource;
            return this;
        }

        public TeamBuilder type(TeamType teamType) {
            this.teamType = teamType;
            return this;
        }

        public Team build() {
            Team team = new Team();
            team.setName(this.name);
            team.setLongName(this.longName);
            team.setLogo(this.logoResource);
            if (this.teamType != null) {
                team.setTeamType(this.teamType);
            }
            return team;
        }
    }
}

