/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.storage;

import de.winkler.betoffice.storage.AbstractStorageObject;
import de.winkler.betoffice.storage.Nickname;
import de.winkler.betoffice.storage.enums.NotificationType;
import de.winkler.betoffice.storage.enums.RoleType;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@Entity
@Table(name="bo_user")
public class User
extends AbstractStorageObject {
    private static final long serialVersionUID = -1806113679051281041L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", updatable=false, nullable=false)
    private Long id;
    @Column(name="bo_name")
    private String name;
    @Column(name="bo_surname")
    private String surname;
    @Embedded
    private Nickname nickname;
    @Column(name="bo_email")
    private String email;
    @Column(name="bo_phone")
    private String phone;
    @Column(name="bo_password")
    private String password;
    @Column(name="bo_automat")
    private boolean automat = false;
    @Column(name="bo_excluded")
    private boolean exclude = false;
    @Column(name="bo_admin")
    private boolean admin = false;
    @Column(name="bo_title")
    private String title;
    @Enumerated
    @Column(name="bo_notification")
    private NotificationType notification = NotificationType.NONE;
    @Column(name="bo_change_token")
    private String changeToken;
    @Column(name="bo_change_email")
    private String changeEmail;
    @Column(name="bo_change_send")
    private Integer changeSend;

    public User() {
    }

    public User(Nickname _nickname) {
        this.nickname = _nickname;
    }

    public User(Nickname nickname, String aName, String aSurname, String aMail, String aPhone, String aPwd, String aTitle, boolean aIsAuto, boolean aIsExcluded) {
        this.setName(aName);
        this.setSurname(aSurname);
        this.setNickname(nickname);
        this.setEmail(aMail);
        this.setPhone(aPhone);
        this.setPassword(aPwd);
        this.setTitle(aTitle);
        this.setAutomat(aIsAuto);
        this.setExcluded(aIsExcluded);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    protected void setId(Long value) {
        this.id = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String value) {
        this.surname = value;
    }

    public Nickname getNickname() {
        return this.nickname;
    }

    public void setNickname(Nickname value) {
        this.nickname = value;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String value) {
        this.email = value;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String value) {
        this.phone = value;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public boolean isAutomat() {
        return this.automat;
    }

    public void setAutomat(boolean value) {
        this.automat = value;
    }

    public boolean isExcluded() {
        return this.exclude;
    }

    public void setExcluded(boolean value) {
        this.exclude = value;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public NotificationType getNotification() {
        return this.notification;
    }

    public void setNotification(NotificationType notification) {
        this.notification = notification;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public void setAdmin(boolean _admin) {
        this.admin = _admin;
    }

    public String getChangeToken() {
        return this.changeToken;
    }

    public void setChangeToken(String changeToken) {
        this.changeToken = changeToken;
    }

    public String getChangeEmail() {
        return this.changeEmail;
    }

    public void setChangeEmail(String changeEmail) {
        this.changeEmail = changeEmail;
    }

    public Integer getChangeSend() {
        return this.changeSend == null ? 0 : this.changeSend;
    }

    public void setChangeSend(Integer changeSend) {
        this.changeSend = changeSend;
    }

    public void incrementChangeSend() {
        this.changeSend = this.changeSend == null ? Integer.valueOf(1) : Integer.valueOf(this.changeSend + 1);
    }

    public void resetChangeSend() {
        this.changeSend = 0;
    }

    public User abortEmailChange() {
        this.changeToken = null;
        this.changeEmail = null;
        this.changeSend = 0;
        return this;
    }

    public User acceptEmailChange() {
        this.email = this.changeEmail;
        this.changeToken = null;
        this.changeEmail = null;
        this.changeSend = 0;
        return this;
    }

    public boolean comparePwd(String value) {
        return StringUtils.equals((CharSequence)value, (CharSequence)this.password);
    }

    public String getDebugInfo() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.name);
        buf.append(": ");
        buf.append(this.surname);
        buf.append(": ");
        buf.append(this.nickname);
        buf.append(": ");
        buf.append(this.email);
        buf.append(": ");
        buf.append(this.phone);
        return buf.toString();
    }

    public List<RoleType> getRoleTypes() {
        ArrayList<RoleType> roleTypes = new ArrayList<RoleType>();
        if (this.isAdmin()) {
            roleTypes.add(RoleType.ADMIN);
        }
        if (!this.isExcluded()) {
            roleTypes.add(RoleType.TIPPER);
        }
        return roleTypes;
    }

    public String toString() {
        return this.getNickname().toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof User)) {
            return false;
        }
        User user = (User)object;
        return user.getNickname().equals(this.getNickname());
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getNickname().hashCode();
        return result;
    }
}

