/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.dao.hibernate;

import de.winkler.betoffice.dao.CommunityRankingDao;
import de.winkler.betoffice.dao.hibernate.AbstractCommonDao;
import de.winkler.betoffice.storage.Community;
import de.winkler.betoffice.storage.GameList;
import de.winkler.betoffice.storage.SeasonRange;
import de.winkler.betoffice.storage.User;
import de.winkler.betoffice.storage.UserResult;
import de.winkler.betoffice.storage.comparator.UserPointsComparator;
import jakarta.persistence.EntityManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.type.StandardBasicTypes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="communityRankingDao")
public class CommunityRankingDaoHibernate
implements CommunityRankingDao {
    private static final String QUERY_SEASON_13_POINTS = AbstractCommonDao.loadQuery("query_userresult_season_13.sql");
    private static final String QUERY_SEASON_10_POINTS = AbstractCommonDao.loadQuery("query_userresult_season_10.sql");
    private static final String QUERY_SEASON_RANGE_13_POINTS = AbstractCommonDao.loadQuery("query_userresult_season_range_13.sql");
    private static final String QUERY_SEASON_RANGE_10_POINTS = AbstractCommonDao.loadQuery("query_userresult_season_range_10.sql");
    private static final String QUERY_SEASON_RANGE_COUNT_MATCHES = AbstractCommonDao.loadQuery("query_countmatches_season_range.sql");
    private static final String QUERY_SEASON_COUNT_MATCHES = AbstractCommonDao.loadQuery("query_countmatches_season.sql");
    private static final String PARAMETER_COMMUNITY_ID = "community_id";
    private static final String PARAMETER_SEASON_ID = "season_id";
    @Autowired
    private EntityManager entityManager;

    @Override
    public List<UserResult> calculateUserRanking(Community community, SeasonRange seasonRange) {
        Set<User> users = community.getUsers();
        HashMap<User, UserResult> resultMap = new HashMap<User, UserResult>();
        for (User user : users) {
            resultMap.put(user, new UserResult(user));
        }
        NativeQuery query13 = ((Session)this.entityManager.unwrap(Session.class)).createNativeQuery(QUERY_SEASON_RANGE_13_POINTS, Object.class).addEntity("user", User.class).addScalar("full_points", StandardBasicTypes.LONG);
        query13.setParameter(PARAMETER_COMMUNITY_ID, (Object)community.getId());
        query13.setParameter("start_index", (Object)seasonRange.startIndex());
        query13.setParameter("end_index", (Object)seasonRange.endIndex());
        List resultQuery13 = query13.list();
        for (Object object : resultQuery13) {
            Object[] row = (Object[])object;
            User user = (User)row[0];
            int fullPoints = ((Long)row[1]).intValue();
            if (resultMap.containsKey(user)) {
                ((UserResult)resultMap.get(user)).setUserWin(fullPoints);
                continue;
            }
            UserResult ur = new UserResult(user);
            ur.setUserWin(fullPoints);
            resultMap.put(user, ur);
        }
        NativeQuery query10 = ((Session)this.entityManager.unwrap(Session.class)).createNativeQuery(QUERY_SEASON_RANGE_10_POINTS, Object.class).addEntity("user", User.class).addScalar("half_points", StandardBasicTypes.LONG);
        query10.setParameter(PARAMETER_COMMUNITY_ID, (Object)community.getId());
        query10.setParameter("start_index", (Object)seasonRange.startIndex());
        query10.setParameter("end_index", (Object)seasonRange.endIndex());
        List resultQuery10 = query10.list();
        for (Object object : resultQuery10) {
            Object[] row = (Object[])object;
            User user = (User)row[0];
            int halfPoints = ((Long)row[1]).intValue();
            if (resultMap.containsKey(user)) {
                ((UserResult)resultMap.get(user)).setUserTotoWin(halfPoints);
                continue;
            }
            UserResult ur = new UserResult(user);
            ur.setUserTotoWin(halfPoints);
            resultMap.put(user, ur);
        }
        NativeQuery queryMatches = ((Session)this.entityManager.unwrap(Session.class)).createNativeQuery(QUERY_SEASON_RANGE_COUNT_MATCHES, Object.class).addScalar("count_matches", StandardBasicTypes.LONG);
        queryMatches.setParameter(PARAMETER_SEASON_ID, (Object)community.getSeason().getId());
        queryMatches.setParameter("start_index", (Object)seasonRange.startIndex());
        queryMatches.setParameter("end_index", (Object)seasonRange.endIndex());
        Long countMatches = (Long)queryMatches.uniqueResult();
        return this.userResultMapToList(resultMap, countMatches.intValue());
    }

    @Override
    public List<UserResult> calculateUserRanking(Community community, GameList round) {
        return this.calculateUserRanking(community, SeasonRange.of(round.getIndex(), round.getIndex()));
    }

    @Override
    public List<UserResult> calculateUserRanking(Community community) {
        Set<User> users = community.getUsers();
        HashMap<User, UserResult> resultMap = new HashMap<User, UserResult>();
        for (User user : users) {
            resultMap.put(user, new UserResult(user));
        }
        NativeQuery query13 = ((Session)this.entityManager.unwrap(Session.class)).createNativeQuery(QUERY_SEASON_13_POINTS, Object.class).addEntity("user", User.class).addScalar("full_points", StandardBasicTypes.LONG);
        query13.setParameter(PARAMETER_COMMUNITY_ID, (Object)community.getId());
        List resultQuery13 = query13.list();
        for (Object object : resultQuery13) {
            Object[] row = (Object[])object;
            User user = (User)row[0];
            int fullPoints = ((Long)row[1]).intValue();
            if (resultMap.containsKey(user)) {
                ((UserResult)resultMap.get(user)).setUserWin(fullPoints);
                continue;
            }
            UserResult ur = new UserResult(user);
            ur.setUserWin(fullPoints);
            resultMap.put(user, ur);
        }
        NativeQuery query10 = ((Session)this.entityManager.unwrap(Session.class)).createNativeQuery(QUERY_SEASON_10_POINTS, Object.class).addEntity("user", User.class).addScalar("half_points", StandardBasicTypes.LONG);
        query10.setParameter(PARAMETER_COMMUNITY_ID, (Object)community.getId());
        List resultQuery10 = query10.list();
        for (Object object : resultQuery10) {
            Object[] row = (Object[])object;
            User user = (User)row[0];
            int halfPoints = ((Long)row[1]).intValue();
            if (resultMap.containsKey(user)) {
                ((UserResult)resultMap.get(user)).setUserTotoWin(halfPoints);
                continue;
            }
            UserResult ur = new UserResult(user);
            ur.setUserTotoWin(halfPoints);
            resultMap.put(user, ur);
        }
        NativeQuery queryMatches = ((Session)this.entityManager.unwrap(Session.class)).createNativeQuery(QUERY_SEASON_COUNT_MATCHES, Object.class).addScalar("count_matches", StandardBasicTypes.LONG);
        queryMatches.setParameter(PARAMETER_SEASON_ID, (Object)community.getSeason().getId());
        Long countMatches = (Long)queryMatches.uniqueResult();
        return this.userResultMapToList(resultMap, countMatches.intValue());
    }

    private List<UserResult> userResultMapToList(Map<User, UserResult> resultMap, int countMatches) {
        ArrayList<UserResult> userResults = new ArrayList<UserResult>();
        userResults.addAll(resultMap.values());
        Collections.sort(userResults, new UserPointsComparator());
        int tabpos = 1;
        for (UserResult userResult : userResults) {
            userResult.setTicket(countMatches - userResult.getUserTotoWin() - userResult.getUserWin());
            userResult.setTabPos(tabpos);
            ++tabpos;
        }
        return userResults;
    }
}

