/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.dao.hibernate;

import de.winkler.betoffice.dao.GoalDao;
import de.winkler.betoffice.dao.hibernate.AbstractCommonDao;
import de.winkler.betoffice.storage.Game;
import de.winkler.betoffice.storage.Goal;
import jakarta.persistence.TypedQuery;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Repository;

@Repository(value="goalDao")
public class GoalDaoHibernate
extends AbstractCommonDao<Goal>
implements GoalDao {
    public GoalDaoHibernate() {
        super(Goal.class);
    }

    @Override
    public List<Goal> findAll() {
        return this.getEntityManager().createQuery("select goal from Goal goal inner join fetch goal.player order by goal.id", Goal.class).getResultList();
    }

    @Override
    public Optional<Goal> findByOpenligaid(long openligaid) {
        TypedQuery query = this.getEntityManager().createQuery("select goal from Goal goal where goal.openligaid = :openligaid", Goal.class).setParameter("openligaid", (Object)openligaid);
        return GoalDaoHibernate.singleResult(query);
    }

    @Override
    public List<Goal> find(Game match) {
        return this.find(match.getId());
    }

    @Override
    public List<Goal> find(long matchId) {
        List goals = this.getEntityManager().createQuery("select goal from Goal goal where goal.game.id = :matchId order by goal.minute", Goal.class).setParameter("matchId", (Object)matchId).getResultList();
        return goals;
    }

    @Override
    public void deleteAll(Game game) {
        this.getEntityManager().createNativeQuery("DELETE bo_goal g WHERE g.bo_game_ref = :gameId").setParameter("gameId", (Object)game.getId());
    }
}

