/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.mail;

import de.winkler.betoffice.conf.BetofficeProperties;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.Message;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.util.Properties;
import org.springframework.stereotype.Component;

@Component
public class MailTask {
    private final Authenticator authenticator;
    private final Properties mailProperties;
    private final boolean mailEnabled;

    public MailTask(final BetofficeProperties betofficeProperties) {
        this.mailEnabled = betofficeProperties.isMailEnabled();
        this.authenticator = new Authenticator(this){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(betofficeProperties.getMailUsername(), betofficeProperties.getMailPassword());
            }
        };
        this.mailProperties = new Properties();
        this.mailProperties.put("mail.smtp.auth", Boolean.toString(betofficeProperties.getMailSmtpAuth()));
        this.mailProperties.put("mail.smtp.starttls.enable", Boolean.toString(betofficeProperties.getMailStartTlsEnable()));
        this.mailProperties.put("mail.smtp.host", betofficeProperties.getMailHost());
        this.mailProperties.put("mail.smtp.port", betofficeProperties.getMailPort());
    }

    public void send(String from, String to, String subject, String message) throws Exception {
        if (this.mailEnabled) {
            Session session = Session.getInstance((Properties)this.mailProperties, (Authenticator)this.authenticator);
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setFrom((Address)new InternetAddress(from));
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to));
            mimeMessage.setSubject(subject);
            mimeMessage.setText(message);
            Transport.send((Message)mimeMessage);
        }
    }
}

