/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.service;

import de.winkler.betoffice.storage.Community;
import de.winkler.betoffice.storage.CommunityFilter;
import de.winkler.betoffice.storage.CommunityReference;
import de.winkler.betoffice.storage.Nickname;
import de.winkler.betoffice.storage.SeasonReference;
import de.winkler.betoffice.storage.User;
import de.winkler.betoffice.validation.BetofficeServiceResult;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public interface CommunityService {
    public static final String DEFAULT_PLAYER_GROUP = "TDKB";

    public static CommunityReference defaultPlayerGroup(SeasonReference seasonReference) {
        return CommunityReference.of(String.format("%s %s", DEFAULT_PLAYER_GROUP, seasonReference.getYear()));
    }

    public Community find(Long var1);

    public Optional<Community> find(CommunityReference var1);

    public List<Community> find(String var1);

    public Set<User> findMembers(CommunityReference var1);

    public Page<Community> findCommunities(CommunityFilter var1, Pageable var2);

    public BetofficeServiceResult<Community> create(CommunityReference var1, SeasonReference var2, String var3, String var4, Nickname var5);

    public void delete(CommunityReference var1);

    public Community addMember(CommunityReference var1, Nickname var2);

    public Community addMembers(CommunityReference var1, Set<Nickname> var2);

    public Community removeMember(CommunityReference var1, Nickname var2);

    public Community removeMembers(CommunityReference var1, Set<Nickname> var2);

    public Page<User> findUsers(String var1, Pageable var2);

    public List<User> findAllUsers();

    public Optional<User> findUser(Nickname var1);

    public User createUser(User var1);

    public void deleteUser(Nickname var1);

    public Optional<User> updateUser(boolean var1, Nickname var2, String var3, String var4, String var5, boolean var6, String var7);

    public Optional<User> confirmMailAddressChange(Nickname var1, String var2);

    public Optional<User> resubmitConfirmationMail(Nickname var1);

    public Optional<User> abortMailAddressChange(Nickname var1);

    public User findUser(long var1);

    public Optional<User> findUserByChangeToken(String var1);
}

