/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.validation;

import de.winkler.betoffice.validation.DefaultServiceResult;
import de.winkler.betoffice.validation.ValidationMessage;
import de.winkler.betoffice.validation.ValidationMessages;
import java.util.Optional;
import java.util.function.Supplier;

public interface ServiceResult<T> {
    public Optional<T> result();

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> var1) throws X;

    public T orElseThrow();

    public ValidationMessages messages();

    public boolean containsAnError();

    public boolean isSuccessful();

    public static <T> ServiceResult<T> sucess(T result) {
        return DefaultServiceResult.sucess(result);
    }

    public static <T> ServiceResult<T> failure() {
        return DefaultServiceResult.failure();
    }

    public static <T> ServiceResult<T> failure(ValidationMessage validationMessage) {
        return DefaultServiceResult.failure(validationMessage);
    }

    public static <T> ServiceResult<T> failure(ValidationMessage.MessageType errorType) {
        return DefaultServiceResult.failure(errorType);
    }

    public static <T> ServiceResult<T> failureWithFormattedError(ValidationMessage.MessageType errorType, String messageParam) {
        return DefaultServiceResult.failureWithFormattedError(errorType, new Object[]{messageParam});
    }
}

