/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.validation;

public class ValidationMessage {
    private final Object[] messageParams;
    private final Severity severity;
    private final MessageType messageType;

    public static ValidationMessage error() {
        return new ValidationMessage(Severity.ERROR, MessageType.UNKNOWN_ERROR, new Object[0]);
    }

    public static ValidationMessage error(MessageType messageType) {
        return new ValidationMessage(Severity.ERROR, messageType, new Object[0]);
    }

    public static ValidationMessage error(MessageType messageType, Object ... messageParams) {
        return new ValidationMessage(Severity.ERROR, messageType, messageParams);
    }

    public static ValidationMessage ok() {
        return new ValidationMessage(Severity.OK, MessageType.NO_ERROR, new Object[0]);
    }

    private ValidationMessage(Severity severity, MessageType messageType, Object ... messageParams) {
        this.messageType = messageType;
        this.severity = severity;
        this.messageParams = messageParams;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public Object[] getMessageParams() {
        return this.messageParams;
    }

    public boolean isOk() {
        return Severity.OK.equals((Object)this.severity);
    }

    public boolean isAnError() {
        return Severity.ERROR.equals((Object)this.severity);
    }

    public String getMessage() {
        if (this.messageParams == null) {
            return this.getMessageType().message();
        }
        return this.getMessageType().formattedMessage(this.messageParams);
    }

    public static enum Severity {
        OK,
        ERROR,
        WARNING,
        INFO;

    }

    public static enum MessageType implements Message
    {
        NO_ERROR(""),
        UNKNOWN_ERROR("Unbekannter Fehler."),
        COMMUNITY_EXISTS("Die Community %s existiert nicht."),
        EMAIL_CHANGE_DATETIME_IS_IN_THE_FUTURE("Der Best\u00e4tigungsmail wurde in der Zukunft verschickt."),
        EMAIL_CHANGE_DATETIME_EXPIRED("Die Best\u00e4tigungslink f\u00fcr die \u00c4nderung der Email-Adresse ist nicht mehr g\u00fcltig."),
        USER_NOT_FOUND("Der Nutzer %s ist nicht bekannt."),
        NICKNAME_IS_NOT_SET("Nickname ist nicht gesetzt."),
        GROUP_TYPE_NAME_IS_NOT_SET("Gruppentyp Name ist nicht gesetzt."),
        TEAM_NAME_IS_NOT_SET("Mannschaftsname ist nicht gesetzt."),
        TEAM_ALIAS_NAME_IS_NOT_SET("Alias Mannschaftsname ist nicht gesetzt."),
        TEAM_ALREADY_EXISTS("Mannschaftsname ist bereits vorhanden."),
        SEASON_DELETE_NOT_POSSIBE_COMMUNITIES_EXISTS("Die Meisterschaft kann nicht entfernt werden, da Communities zu der Meisterschaft existieren."),
        SEASON_DELETE_NOT_POSSIBLE_ROUNDS_EXISTS("Die Meisterschaft kann nicht entfernt werden, da Spieltage zu der Meisterschaft existieren."),
        SEASON_DELETE_NOT_POSSIBLE_GROUPS_EXISTS("Die Meisterschaft kann nicht entfernt werden, da Gruppen der Meisterschaft zugeordnet sind."),
        SEASON_DOES_NOT_SUPPORT_THIS_TEAM_TYPE("Die Meisterschaft %s unterst\u00fctzt diesen Mannschaftstyp %s nicht."),
        SEASON_GROUP_TEAM_IS_ALREADY_A_MEMBER("Die Mannschaft '%s' ist bereits Teil der Meisterschaft '%s' f\u00fcr die Gruppe '%s'."),
        ROUND_ID_NOT_FOUND("Eine Spielrunde mit der ID '%d' ist nicht vorhanden.");

        private final String message;

        private MessageType(String message) {
            this.message = message;
        }

        @Override
        public String key() {
            return this.name();
        }

        @Override
        public String message() {
            return this.message;
        }

        @Override
        public String formattedMessage(Object ... s) {
            return String.format(this.message(), s);
        }
    }

    public static interface Message {
        public String key();

        public String message();

        public String formattedMessage(Object ... var1);
    }
}

