/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.dao.hibernate;

import de.winkler.betoffice.dao.GroupDao;
import de.winkler.betoffice.dao.hibernate.AbstractCommonDao;
import de.winkler.betoffice.storage.Group;
import de.winkler.betoffice.storage.GroupType;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.Team;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository(value="groupDao")
public class GroupDaoHibernate
extends AbstractCommonDao<Group>
implements GroupDao {
    private static final String QUERY_GROUPS_FROM_SEASON = AbstractCommonDao.loadQuery("hql_groups_season.sql");
    private static final String QUERY_TEAMS_BY_GROUP = AbstractCommonDao.loadQuery("query_teams_group.sql");
    private static final String QUERY_GROUP_BY_SEASON_AND_GROUPTYPE = "select grp  from Group as grp    inner join fetch grp.season as season    inner join fetch grp.groupType as gt    left join fetch grp.teams teams  where    season.id = :seasonId   and gt.id = :groupTypeId";

    public GroupDaoHibernate() {
        super(Group.class);
    }

    @Override
    public List<Group> findAll() {
        List groups = this.getEntityManager().createQuery("select g from group g", Group.class).getResultList();
        return groups;
    }

    @Override
    public List<Group> findBySeason(Season season) {
        List objects = this.getEntityManager().createQuery(QUERY_GROUPS_FROM_SEASON, Group.class).setParameter("seasonId", (Object)season.getId()).getResultList();
        return objects;
    }

    @Override
    public List<Team> findTeams(Group group) {
        Query query = this.getEntityManager().createNativeQuery(QUERY_TEAMS_BY_GROUP, Team.class).setParameter("group_id", (Object)group.getId());
        List teams = query.getResultList();
        return teams;
    }

    @Override
    public Group findBySeasonAndGroupType(Season season, GroupType groupType) {
        TypedQuery query = this.getEntityManager().createQuery(QUERY_GROUP_BY_SEASON_AND_GROUPTYPE, Group.class).setParameter("seasonId", (Object)season.getId()).setParameter("groupTypeId", (Object)groupType.getId());
        return (Group)query.getSingleResult();
    }
}

