/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.dao.hibernate;

import de.winkler.betoffice.dao.TeamAliasDao;
import de.winkler.betoffice.dao.hibernate.AbstractCommonDao;
import de.winkler.betoffice.storage.Team;
import de.winkler.betoffice.storage.TeamAlias;
import java.util.List;
import java.util.Optional;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.springframework.stereotype.Repository;

@Repository(value="teamAliasDao")
public class TeamAliasDaoHibernate
extends AbstractCommonDao<TeamAlias>
implements TeamAliasDao {
    private static final String QUERY_TEAMALIAS_BY_NAME = "select t.id, t.bo_name, t.bo_longname, t.bo_shortname, t.bo_xshortname, t.bo_logo, t.bo_teamtype, t.bo_location_ref, t.bo_openligaid from bo_team t, bo_teamalias ta where ta.bo_aliasname like :alias_name   and ta.bo_team_ref = t.id";
    private static final String QUERY_TEAMALIAS_BY_TEAM = "select ta from " + TeamAlias.class.getName() + " as ta where ta.team.id = :teamId";
    private static final String QUERY_TEAMALIAS_FINDALL = "select ta from " + TeamAlias.class.getName() + " as ta order by ta.aliasName";

    public TeamAliasDaoHibernate() {
        super(TeamAlias.class);
    }

    @Override
    public List<TeamAlias> findAll() {
        return this.getEntityManager().createQuery(QUERY_TEAMALIAS_FINDALL, TeamAlias.class).getResultList();
    }

    @Override
    public Optional<Team> findByAliasName(String aliasName) {
        NativeQuery query = ((Session)this.getEntityManager().unwrap(Session.class)).createNativeQuery(QUERY_TEAMALIAS_BY_NAME, Team.class).setParameter("alias_name", (Object)aliasName);
        return TeamAliasDaoHibernate.singleResult(query);
    }

    @Override
    public List<TeamAlias> findAliasNames(Team team) {
        List teams = this.getEntityManager().createQuery(QUERY_TEAMALIAS_BY_TEAM, TeamAlias.class).setParameter("teamId", (Object)team.getId()).getResultList();
        return teams;
    }
}

