/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.mail;

import de.winkler.betoffice.mail.MailTask;
import de.winkler.betoffice.service.CommunityService;
import de.winkler.betoffice.service.DateTimeProvider;
import de.winkler.betoffice.service.SeasonManagerService;
import de.winkler.betoffice.service.TippService;
import de.winkler.betoffice.storage.Game;
import de.winkler.betoffice.storage.GameList;
import de.winkler.betoffice.storage.GameTipp;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.User;
import de.winkler.betoffice.storage.enums.NotificationType;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SendReminderMailNotification {
    private static final Logger LOG = LoggerFactory.getLogger(SendReminderMailNotification.class);
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-dd-MM HH:mm");
    private final DateTimeProvider dateTimeProvider;
    private final TippService tippService;
    private final CommunityService communityService;
    private final SeasonManagerService seasonManagerService;
    private final MailTask mailTask;

    public SendReminderMailNotification(DateTimeProvider dateTimeProvider, SeasonManagerService seasonManagerService, TippService tippService, CommunityService communityService, MailTask mailTask) {
        this.dateTimeProvider = dateTimeProvider;
        this.seasonManagerService = seasonManagerService;
        this.tippService = tippService;
        this.communityService = communityService;
        this.mailTask = mailTask;
    }

    public Optional<GameList> findNextTippRound() {
        return this.tippService.findNextTippRound(this.dateTimeProvider.currentDateTime());
    }

    public void send() {
        LocalDate localNow = this.dateTimeProvider.currentDateTime().toLocalDate();
        Optional<GameList> nextTippRound = this.findNextTippRound();
        nextTippRound.ifPresent(nxtr -> {
            Season season = ((GameList)nextTippRound.get()).getSeason();
            List<Game> matches = this.seasonManagerService.findMatches((GameList)nxtr);
            if (!matches.isEmpty() && matches.get(0).getDateTime().toLocalDate().compareTo(localNow) == 0) {
                Set<User> members = this.communityService.findMembers(CommunityService.defaultPlayerGroup(season.getReference()));
                members.stream().filter(SendReminderMailNotification::userWantsToBeNotified).forEach(u -> {
                    try {
                        List<GameTipp> sortedTipps = SendReminderMailNotification.sort(this.tippService.findTipps((GameList)nxtr, (User)u));
                        ArrayList<Pair> gameWithTipp = new ArrayList<Pair>();
                        for (Game m : matches) {
                            boolean findTipp = false;
                            for (GameTipp t : sortedTipps) {
                                if (!m.equals(t.getGame())) continue;
                                gameWithTipp.add(new Pair(m, t));
                                findTipp = true;
                            }
                            if (findTipp) continue;
                            gameWithTipp.add(new Pair(m, null));
                        }
                        StringBuilder sb = new StringBuilder();
                        sb.append("Heute ist Spieltag. Vergiss deinen Tipp nicht: https://tippdiekistebier.de\n");
                        sb.append("F\u00fcr den aktuellen Spieltag liegen die folgenden Tipps von dir vor:");
                        for (Pair gwt : gameWithTipp) {
                            sb.append("\n").append(gwt.game().getDateTime().format(formatter)).append(" ").append(gwt.game().getHomeTeam().getName()).append(" - ").append(gwt.game().getGuestTeam().getName());
                            if (gwt.gameTipp() == null) {
                                sb.append(" -nicht vorhanden-");
                                continue;
                            }
                            sb.append(" ").append(gwt.gameTipp().getTipp().getHomeGoals()).append(":").append(gwt.gameTipp().getTipp().getGuestGoals());
                        }
                        this.mailTask.send("betoffice@andre-winkler.de", u.getEmail(), "Spieltag!", sb.toString());
                    }
                    catch (Exception ex) {
                        LOG.error(String.format("Unable to send an email to %s", u.getEmail()), (Throwable)ex);
                    }
                });
            }
        });
    }

    public static boolean userWantsToBeNotified(User user) {
        return NotificationType.TIPP.equals((Object)user.getNotification());
    }

    public static List<GameTipp> sort(List<GameTipp> gameTipps) {
        ArrayList<GameTipp> sortedTipps = new ArrayList<GameTipp>(gameTipps);
        sortedTipps.sort(new Comparator<GameTipp>(){

            @Override
            public int compare(GameTipp o1, GameTipp o2) {
                return o1.getGame().getDateTime().compareTo(o2.getGame().getDateTime());
            }
        });
        return sortedTipps;
    }

    private record Pair(Game game, GameTipp gameTipp) {
    }
}

