/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.service;

import de.winkler.betoffice.dao.GroupTypeDao;
import de.winkler.betoffice.dao.LocationDao;
import de.winkler.betoffice.dao.PlayerDao;
import de.winkler.betoffice.dao.SeasonDao;
import de.winkler.betoffice.dao.TeamAliasDao;
import de.winkler.betoffice.dao.TeamDao;
import de.winkler.betoffice.service.AbstractManagerService;
import de.winkler.betoffice.service.MasterDataManagerService;
import de.winkler.betoffice.storage.GroupType;
import de.winkler.betoffice.storage.Location;
import de.winkler.betoffice.storage.Player;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.Team;
import de.winkler.betoffice.storage.TeamAlias;
import de.winkler.betoffice.storage.enums.TeamType;
import de.winkler.betoffice.validation.ValidationException;
import de.winkler.betoffice.validation.ValidationMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="masterDataManagerService")
public class DefaultMasterDataManagerService
extends AbstractManagerService
implements MasterDataManagerService {
    @Autowired
    private SeasonDao seasonDao;
    @Autowired
    private GroupTypeDao groupTypeDao;
    @Autowired
    private TeamDao teamDao;
    @Autowired
    private TeamAliasDao teamAliasDao;
    @Autowired
    private LocationDao locationDao;
    @Autowired
    private PlayerDao playerDao;

    @Override
    @Transactional
    public void createSeason(Season season) {
        this.seasonDao.persist(season);
    }

    @Override
    @Transactional
    public void updateSeason(Season season) {
        this.seasonDao.update(season);
    }

    @Override
    @Transactional
    public void createGroupType(GroupType groupType) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (StringUtils.isBlank((CharSequence)groupType.getName())) {
            messages.add(ValidationMessage.error(ValidationMessage.MessageType.GROUP_TYPE_NAME_IS_NOT_SET));
        }
        if (!messages.isEmpty()) {
            throw new ValidationException(messages);
        }
        this.groupTypeDao.persist(groupType);
    }

    @Override
    @Transactional
    public void createTeam(Team team) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (StringUtils.isBlank((CharSequence)team.getName())) {
            messages.add(ValidationMessage.error(ValidationMessage.MessageType.TEAM_NAME_IS_NOT_SET));
        }
        if (!messages.isEmpty()) {
            throw new ValidationException(messages);
        }
        this.teamDao.persist(team);
    }

    @Override
    @Transactional
    public TeamAlias createTeamAlias(Team team, String teamAliasName) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (StringUtils.isBlank((CharSequence)teamAliasName)) {
            messages.add(ValidationMessage.error(ValidationMessage.MessageType.TEAM_ALIAS_NAME_IS_NOT_SET));
        }
        TeamAlias teamAlias = null;
        if (!messages.isEmpty()) {
            throw new ValidationException(messages);
        }
        teamAlias = new TeamAlias();
        teamAlias.setAliasName(teamAliasName);
        teamAlias.setTeam(team);
        this.teamAliasDao.persist(teamAlias);
        return teamAlias;
    }

    @Override
    @Transactional
    public void deleteGroupType(GroupType groupType) {
        GroupType persistentGroupType = (GroupType)this.groupTypeDao.findById(groupType.getId());
        this.groupTypeDao.delete(persistentGroupType);
    }

    @Override
    @Transactional
    public void deleteTeam(Team team) {
        Team persistentTeam = (Team)this.teamDao.findById(team.getId());
        this.teamDao.delete(persistentTeam);
    }

    @Override
    @Transactional
    public void deleteTeamAlias(TeamAlias teamAlias) {
        TeamAlias persistentTeamAlias = (TeamAlias)this.teamAliasDao.findById(teamAlias.getId());
        this.teamAliasDao.delete(persistentTeamAlias);
    }

    @Override
    @Transactional(readOnly=true)
    public List<GroupType> findAllGroupTypes() {
        return this.groupTypeDao.findAll();
    }

    @Override
    @Transactional(readOnly=true)
    public List<Team> findAllTeams() {
        return this.teamDao.findAll();
    }

    @Override
    @Transactional(readOnly=true)
    public List<Team> findTeams(TeamType teamType) {
        return this.teamDao.findTeams(teamType);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Team> findTeams(Optional<TeamType> teamType, String filter) {
        return this.teamDao.findTeams(teamType, filter);
    }

    @Override
    @Transactional(readOnly=true)
    public List<TeamAlias> findAllTeamAlias(Team team) {
        return this.teamAliasDao.findAliasNames(team);
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<GroupType> findGroupType(String name) {
        return this.groupTypeDao.findByName(name);
    }

    @Override
    @Transactional(readOnly=true)
    public GroupType findGroupType(long groupTypeId) {
        return (GroupType)this.groupTypeDao.findById(groupTypeId);
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<Team> findTeam(String name) {
        return this.teamDao.findByName(name);
    }

    @Override
    @Transactional(readOnly=true)
    public Team findTeamById(long id) {
        return (Team)this.teamDao.findById(id);
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<Team> findTeamByAlias(String aliasName) {
        return this.teamAliasDao.findByAliasName(aliasName);
    }

    @Override
    @Transactional
    public void updateGroupType(GroupType groupType) {
        this.groupTypeDao.update(groupType);
    }

    @Override
    @Transactional
    public void updateTeam(Team team) {
        this.teamDao.update(team);
    }

    @Override
    @Transactional
    public void updateTeamAlias(TeamAlias teamAlias) {
        this.teamAliasDao.update(teamAlias);
    }

    @Override
    @Transactional(readOnly=false)
    public Optional<Team> findTeamByOpenligaid(long id) {
        return this.teamDao.findByOpenligaid(id);
    }

    @Override
    @Transactional
    public void createLocation(Location location) {
        this.locationDao.persist(location);
    }

    @Override
    @Transactional
    public void deleteLocation(Location location) {
        this.locationDao.delete(location);
    }

    @Override
    @Transactional
    public void updateLocation(Location location) {
        this.locationDao.update(location);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Location> findAllLocations() {
        return this.locationDao.findAll();
    }

    @Override
    @Transactional(readOnly=true)
    public Location findLocation(long id) {
        return (Location)this.locationDao.findById(id);
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<Location> findLocationByOpenligaid(long openligaid) {
        return this.locationDao.findByOpenligaid(openligaid);
    }

    @Override
    @Transactional
    public void createPlayer(Player player) {
        this.playerDao.persist(player);
    }

    @Override
    @Transactional
    public void deletePlayer(Player player) {
        this.playerDao.delete(player);
    }

    @Override
    @Transactional
    public void updatePlayer(Player player) {
        this.playerDao.update(player);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Player> findAllPlayers() {
        return this.playerDao.findAll();
    }

    @Override
    @Transactional(readOnly=true)
    public Player findPlayer(long id) {
        return (Player)this.playerDao.findById(id);
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<Player> findPlayerByOpenligaid(long openligaid) {
        return this.playerDao.findByOpenligaid(openligaid);
    }
}

