/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.validation;

import de.betoffice.validation.DefaultServiceResult;
import de.betoffice.validation.ValidationMessage;
import de.betoffice.validation.ValidationMessages;
import java.util.Optional;
import java.util.function.Supplier;

public interface ServiceResult<T> {
    public Optional<T> result();

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> var1) throws X;

    public T orElseThrow();

    public ValidationMessages messages();

    public boolean containsAnError();

    public boolean isSuccessful();

    public static <T> ServiceResult<T> sucess(T result) {
        return DefaultServiceResult.sucess(result);
    }

    public static <T> ServiceResult<T> failure() {
        return DefaultServiceResult.failure();
    }

    public static <T> ServiceResult<T> failure(ValidationMessage validationMessage) {
        return DefaultServiceResult.failure(validationMessage);
    }

    public static <T> ServiceResult<T> failure(ValidationMessage.MessageType errorType) {
        return DefaultServiceResult.failure(errorType);
    }

    public static <T> ServiceResult<T> failureWithFormattedError(ValidationMessage.MessageType errorType, String messageParam) {
        return DefaultServiceResult.failureWithFormattedError(errorType, new Object[]{messageParam});
    }
}

